/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.zipfile;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.dataformat.zipfile.ZipIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public class ZipFileDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean usingIterator;
    private boolean allowEmptyDirectory;

    public String getDataFormatName() {
        return "zipFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        filename = filename == null ? StringHelper.sanitize((String)exchange.getIn().getMessageId()) : Paths.get(filename, new String[0]).getFileName().toString();
        ZipOutputStream zos = new ZipOutputStream(stream);
        zos.putNextEntry(new ZipEntry(filename));
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        try {
            IOHelper.copy((InputStream)is, (OutputStream)zos);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, zos});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, zos});
        String newFilename = filename + ".zip";
        exchange.getOut().setHeader("CamelFileName", (Object)newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        if (this.usingIterator) {
            ZipIterator zipIterator = new ZipIterator(exchange.getIn());
            zipIterator.setAllowEmptyDirectory(this.allowEmptyDirectory);
            return zipIterator;
        }
        ZipInputStream zis = new ZipInputStream(inputStream);
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
        try {
            ZipEntry entry = zis.getNextEntry();
            if (entry != null) {
                exchange.getOut().setHeader("CamelFileName", (Object)entry.getName());
                IOHelper.copy((InputStream)zis, (OutputStream)osb);
            }
            if ((entry = zis.getNextEntry()) != null) {
                throw new IllegalStateException("Zip file has more than 1 entry.");
            }
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{zis, osb});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{zis, osb});
        return object;
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    public boolean isAllowEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public void setAllowEmptyDirectory(boolean allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

