/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.reactive.streams.ReactiveStreamsEndpoint;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreams;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveStreamsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveStreamsConsumer.class);
    private ReactiveStreamsEndpoint endpoint;
    private ExecutorService executor;
    private CamelReactiveStreamsService service;

    public ReactiveStreamsConsumer(ReactiveStreamsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.service = CamelReactiveStreams.get(this.endpoint.getCamelContext(), this.endpoint.getServiceName());
        int poolSize = this.endpoint.getConcurrentConsumers();
        if (this.executor == null) {
            this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.getEndpoint().getEndpointUri(), poolSize);
        }
        this.service.attachCamelConsumer(this.endpoint.getStream(), this);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.service.detachCamelConsumer(this.endpoint.getStream());
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.getIn().setHeader("CamelReactiveStreamsEventType", (Object)"onNext");
        return this.doSend(exchange, callback);
    }

    public void onComplete() {
        if (this.endpoint.isForwardOnComplete()) {
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setHeader("CamelReactiveStreamsEventType", (Object)"onComplete");
            this.doSend(exchange, done -> {});
        }
    }

    public void onError(Throwable error) {
        if (this.endpoint.isForwardOnError()) {
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setHeader("CamelReactiveStreamsEventType", (Object)"onError");
            exchange.getIn().setBody((Object)error);
            this.doSend(exchange, done -> {});
        }
    }

    private boolean doSend(Exchange exchange, AsyncCallback callback) {
        ExecutorService executorService = this.executor;
        if (executorService != null && this.isRunAllowed()) {
            executorService.execute(() -> this.getAsyncProcessor().process(exchange, doneSync -> {
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
                callback.done(doneSync);
            }));
            return false;
        }
        LOG.warn("Consumer not ready to process exchanges. The exchange {} will be discarded", (Object)exchange);
        callback.done(true);
        return true;
    }

    public ReactiveStreamsEndpoint getEndpoint() {
        return this.endpoint;
    }
}

