/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsComponent;
import org.apache.camel.component.reactive.streams.ReactiveStreamsEndpoint;
import org.apache.camel.component.reactive.streams.ReactiveStreamsProducer;
import org.apache.camel.component.reactive.streams.api.DispatchCallback;
import org.apache.camel.component.reactive.streams.engine.CamelSubscription;
import org.apache.camel.component.reactive.streams.engine.StreamPayload;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPublisher
implements Publisher<StreamPayload<Exchange>>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CamelPublisher.class);
    private ExecutorService workerPool;
    private String name;
    private ReactiveStreamsBackpressureStrategy backpressureStrategy;
    private List<CamelSubscription> subscriptions = new CopyOnWriteArrayList<CamelSubscription>();
    private ReactiveStreamsProducer producer;

    public CamelPublisher(ExecutorService workerPool, CamelContext context, String name) {
        this.workerPool = workerPool;
        this.backpressureStrategy = ((ReactiveStreamsComponent)context.getComponent("reactive-streams")).getBackpressureStrategy();
        this.name = name;
    }

    public void subscribe(Subscriber<? super StreamPayload<Exchange>> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber must not be null");
        CamelSubscription sub = new CamelSubscription(this.workerPool, this, this.name, this.backpressureStrategy, subscriber);
        this.subscriptions.add(sub);
        subscriber.onSubscribe((Subscription)sub);
    }

    public void unsubscribe(CamelSubscription subscription) {
        this.subscriptions.remove(subscription);
    }

    public void publish(StreamPayload<Exchange> data) {
        LinkedList<CamelSubscription> subs = new LinkedList<CamelSubscription>(this.subscriptions);
        DispatchCallback<Exchange> originalCallback = data.getCallback();
        if (originalCallback != null && subs.size() > 0) {
            AtomicInteger counter = new AtomicInteger(subs.size());
            AtomicReference<Object> thrown = new AtomicReference<Object>(null);
            data = new StreamPayload<Exchange>(data.getItem(), (ex, error) -> {
                thrown.compareAndSet(null, error);
                if (counter.decrementAndGet() == 0) {
                    originalCallback.processed((Exchange)ex, (Throwable)thrown.get());
                }
            });
        }
        if (subs.size() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange published to {} subscriptions for the stream {}: {}", new Object[]{subs.size(), this.name, data.getItem()});
            }
            for (CamelSubscription sub : subs) {
                sub.publish(data);
            }
        } else {
            data.getCallback().processed(data.getItem(), new IllegalStateException("The stream has no active subscriptions"));
        }
    }

    public void attachProducer(ReactiveStreamsProducer producer) {
        Objects.requireNonNull(producer, "producer cannot be null, use the detach method");
        if (this.producer != null) {
            throw new IllegalStateException("A producer is already attached to the stream '" + this.name + "'");
        }
        this.producer = producer;
        ReactiveStreamsEndpoint endpoint = producer.getEndpoint();
        if (endpoint.getBackpressureStrategy() != null) {
            this.backpressureStrategy = endpoint.getBackpressureStrategy();
            for (CamelSubscription sub : this.subscriptions) {
                sub.setBackpressureStrategy(endpoint.getBackpressureStrategy());
            }
        }
    }

    public void detachProducer() {
        this.producer = null;
    }

    @Override
    public void close() throws Exception {
        for (CamelSubscription sub : this.subscriptions) {
            sub.signalCompletion();
        }
        this.subscriptions.clear();
    }

    public int getSubscriptionSize() {
        return this.subscriptions.size();
    }
}

