/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class MllpComponent
extends UriEndpointComponent {
    public static final String MLLP_LOG_PHI_PROPERTY = "org.apache.camel.component.mllp.logPHI";

    public MllpComponent() {
        super(MllpEndpoint.class);
    }

    public MllpComponent(CamelContext context) {
        super(context, MllpEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MllpEndpoint endpoint = new MllpEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        int optionsStartIndex = uri.indexOf(63);
        String hostPort = -1 == optionsStartIndex ? uri.substring(7) : uri.substring(7, optionsStartIndex);
        int colonIndex = hostPort.indexOf(58);
        if (-1 != colonIndex) {
            endpoint.setHostname(hostPort.substring(0, colonIndex));
            endpoint.setPort(Integer.parseInt(hostPort.substring(colonIndex + 1)));
        } else {
            endpoint.setPort(Integer.parseInt(hostPort.substring(colonIndex + 1)));
        }
        return endpoint;
    }

    public static boolean isLogPhi() {
        String logPhiProperty = System.getProperty(MLLP_LOG_PHI_PROPERTY, "true");
        return Boolean.valueOf(logPhiProperty);
    }

    public static String covertToPrintFriendlyString(String hl7Message) {
        if (hl7Message == null) {
            return "null";
        }
        if (hl7Message.isEmpty()) {
            return "empty";
        }
        return hl7Message.replaceAll("\u000b", "<VT>").replaceAll("\u001c", "<FS>").replaceAll("\r", "<CR>").replaceAll("\n", "<LF>");
    }

    public static String covertBytesToPrintFriendlyString(byte[] hl7Bytes) {
        if (hl7Bytes == null) {
            return "null";
        }
        if (hl7Bytes.length == 0) {
            return "";
        }
        return MllpComponent.covertBytesToPrintFriendlyString(hl7Bytes, 0, hl7Bytes.length);
    }

    public static String covertBytesToPrintFriendlyString(byte[] hl7Bytes, int startPosition, int length) {
        if (null == hl7Bytes) {
            return "null";
        }
        if (hl7Bytes.length == 0) {
            return "";
        }
        return MllpComponent.covertToPrintFriendlyString(new String(hl7Bytes, startPosition, length));
    }
}

