/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpTcpClientProducer;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.17.0", scheme="mllp", title="MLLP", syntax="mllp:hostname:port", consumerClass=MllpTcpServerConsumer.class, label="hl7")
public class MllpEndpoint
extends DefaultEndpoint {
    public static final char START_OF_BLOCK = '\u000b';
    public static final char END_OF_BLOCK = '\u001c';
    public static final char END_OF_DATA = '\r';
    public static final int END_OF_STREAM = -1;
    public static final char SEGMENT_DELIMITER = '\r';
    public static final char MESSAGE_TERMINATOR = '\n';
    private static final Logger LOG = LoggerFactory.getLogger(MllpEndpoint.class);
    @UriPath
    @Metadata(required="true")
    String hostname;
    @UriPath
    @Metadata(required="true")
    int port = -1;
    @UriParam(label="advanced", defaultValue="5")
    int backlog = 5;
    @UriParam(label="timeout", defaultValue="30000")
    int bindTimeout = 30000;
    @UriParam(label="timeout", defaultValue="5000")
    int bindRetryInterval = 5000;
    @UriParam(label="timeout", defaultValue="60000")
    int acceptTimeout = 60000;
    @UriParam(label="timeout", defaultValue="30000")
    int connectTimeout = 30000;
    @UriParam(label="timeout", defaultValue="10000")
    int receiveTimeout = 10000;
    @UriParam(label="timeout", defaultValue="-1")
    int maxReceiveTimeouts = -1;
    @UriParam(label="timeout", defaultValue="500")
    int readTimeout = 500;
    @UriParam(defaultValue="true")
    boolean keepAlive = true;
    @UriParam(defaultValue="true")
    boolean tcpNoDelay = true;
    @UriParam
    boolean reuseAddress;
    @UriParam(label="advanced")
    Integer receiveBufferSize;
    @UriParam(label="advanced")
    Integer sendBufferSize;
    @UriParam(defaultValue="true")
    boolean autoAck = true;
    @UriParam(defaultValue="true")
    boolean hl7Headers = true;
    @UriParam(defaultValue="true")
    boolean bufferWrites = true;
    @UriParam(defaultValue="false")
    boolean validatePayload;
    @UriParam(label="codec")
    String charsetName;

    public MllpEndpoint(String uri, MllpComponent component) {
        super(uri, (Component)component);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    public Exchange createExchange(ExchangePattern exchangePattern) {
        Exchange mllpExchange = super.createExchange(exchangePattern);
        this.setExchangeProperties(mllpExchange);
        return mllpExchange;
    }

    public Exchange createExchange(Exchange exchange) {
        Exchange mllpExchange = super.createExchange(exchange);
        this.setExchangeProperties(mllpExchange);
        return mllpExchange;
    }

    private void setExchangeProperties(Exchange mllpExchange) {
        if (this.charsetName != null) {
            mllpExchange.setProperty("CamelCharsetName", (Object)this.charsetName);
        }
    }

    public Producer createProducer() throws Exception {
        LOG.trace("({}).createProducer()", (Object)this.getEndpointKey());
        return new MllpTcpClientProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.trace("({}).createConsumer(processor)", (Object)this.getEndpointKey());
        MllpTcpServerConsumer consumer = new MllpTcpServerConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSynchronous() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getBindTimeout() {
        return this.bindTimeout;
    }

    public void setBindTimeout(int bindTimeout) {
        this.bindTimeout = bindTimeout;
    }

    public int getBindRetryInterval() {
        return this.bindRetryInterval;
    }

    public void setBindRetryInterval(int bindRetryInterval) {
        this.bindRetryInterval = bindRetryInterval;
    }

    public int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public void setAcceptTimeout(int acceptTimeout) {
        this.acceptTimeout = acceptTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getMaxReceiveTimeouts() {
        return this.maxReceiveTimeouts;
    }

    public void setMaxReceiveTimeouts(int maxReceiveTimeouts) {
        this.maxReceiveTimeouts = maxReceiveTimeouts;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isHl7Headers() {
        return this.hl7Headers;
    }

    public void setHl7Headers(boolean hl7Headers) {
        this.hl7Headers = hl7Headers;
    }

    public boolean isValidatePayload() {
        return this.validatePayload;
    }

    public void setValidatePayload(boolean validatePayload) {
        this.validatePayload = validatePayload;
    }

    public boolean isBufferWrites() {
        return this.bufferWrites;
    }

    public void setBufferWrites(boolean bufferWrites) {
        this.bufferWrites = bufferWrites;
    }
}

