/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.impl;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MllpSocketUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MllpSocketUtil.class);

    private MllpSocketUtil() {
    }

    public static void setSoTimeout(Socket socket, int timeout, Logger logger, String reasonMessage) {
        block6: {
            if (logger != null && logger.isDebugEnabled()) {
                String format = "Setting SO_TIMEOUT to {} for connection {}";
                if (reasonMessage != null && !reasonMessage.isEmpty()) {
                    logger.debug("Setting SO_TIMEOUT to {} for connection {}  Reason: {}", new Object[]{timeout, MllpSocketUtil.getAddressString(socket), reasonMessage});
                } else {
                    logger.debug("Setting SO_TIMEOUT to {} for connection {}", (Object)timeout, (Object)MllpSocketUtil.getAddressString(socket));
                }
            }
            try {
                socket.setSoTimeout(timeout);
            }
            catch (SocketException socketEx) {
                if (logger == null) break block6;
                String format = "Ignoring SocketException encountered setting SO_TIMEOUT to %d for connection %s.";
                if (reasonMessage != null && !reasonMessage.isEmpty()) {
                    logger.warn(String.format("Ignoring SocketException encountered setting SO_TIMEOUT to %d for connection %s.  Reason: %s", timeout, MllpSocketUtil.getAddressString(socket), reasonMessage), (Throwable)socketEx);
                }
                logger.warn(String.format("Ignoring SocketException encountered setting SO_TIMEOUT to %d for connection %s.", timeout, MllpSocketUtil.getAddressString(socket)), (Throwable)socketEx);
            }
        }
    }

    public static void close(Socket socket, Logger logger, String reasonMessage) {
        if (socket != null && socket.isConnected() && !socket.isClosed()) {
            String logMessage;
            String format = "Closing connection {}";
            String address = MllpSocketUtil.getAddressString(socket);
            if (logger != null) {
                if (reasonMessage != null && !reasonMessage.isEmpty()) {
                    logger.warn("Closing connection {}.  Reason: {}", (Object)address, (Object)reasonMessage);
                } else {
                    logger.warn("Closing connection {}", (Object)address);
                }
            }
            if (!socket.isInputShutdown()) {
                try {
                    socket.shutdownInput();
                }
                catch (Exception ex) {
                    logMessage = String.format("Ignoring Exception encountered shutting down the input stream on the client socket %s", address);
                    if (logger != null) {
                        logger.warn(logMessage, (Throwable)ex);
                    }
                    LOG.warn(logMessage, (Throwable)ex);
                }
            }
            if (!socket.isOutputShutdown()) {
                try {
                    socket.shutdownOutput();
                }
                catch (Exception ex) {
                    logMessage = String.format("Ignoring Exception encountered shutting down the output stream on the client socket %s", address);
                    if (logger != null) {
                        logger.warn(logMessage, (Throwable)ex);
                    }
                    LOG.warn(logMessage, (Throwable)ex);
                }
            }
            try {
                socket.close();
            }
            catch (IOException ioEx) {
                logMessage = String.format("Ignoring IOException encountered while closing connection %s", address);
                if (logger != null) {
                    logger.warn(logMessage, (Throwable)ioEx);
                }
                LOG.warn(logMessage, (Throwable)ioEx);
            }
        }
    }

    public static void reset(Socket socket, Logger logger, String reasonMessage) {
        if (socket != null && socket.isConnected() && !socket.isClosed()) {
            String logMessage;
            String format = "Resetting connection {}";
            String address = MllpSocketUtil.getAddressString(socket);
            if (logger != null) {
                if (reasonMessage != null && !reasonMessage.isEmpty()) {
                    logger.warn("Resetting connection {}.  Reason: {}", (Object)address, (Object)reasonMessage);
                } else {
                    logger.warn("Resetting connection {}", (Object)address);
                }
            }
            try {
                socket.setSoLinger(true, 0);
            }
            catch (SocketException socketEx) {
                logMessage = String.format("Ignoring SocketException encountered setting SO_LINGER in preparation for resetting connection %s", address);
                if (logger != null) {
                    logger.warn(logMessage, (Throwable)socketEx);
                }
                LOG.warn(logMessage, (Throwable)socketEx);
            }
            try {
                socket.close();
            }
            catch (IOException ioEx) {
                logMessage = String.format("Ignoring IOException encountered while resetting connection %s", address);
                if (logger != null) {
                    logger.warn(logMessage, (Throwable)ioEx);
                }
                LOG.warn(logMessage, (Throwable)ioEx);
            }
        }
    }

    public static String getAddressString(Socket socket) {
        String localAddressString = "null";
        String remoteAddressString = "null";
        if (socket != null) {
            SocketAddress remoteSocketAddress;
            SocketAddress localSocketAddress = socket.getLocalSocketAddress();
            if (localSocketAddress != null) {
                localAddressString = localSocketAddress.toString();
            }
            if ((remoteSocketAddress = socket.getRemoteSocketAddress()) != null) {
                remoteAddressString = remoteSocketAddress.toString();
            }
        }
        return String.format("%s -> %s", localAddressString, remoteAddressString);
    }

    public static int findStartOfBlock(byte[] payload) {
        if (payload != null) {
            return MllpSocketUtil.findStartOfBlock(payload, payload.length);
        }
        return -1;
    }

    public static int findStartOfBlock(byte[] payload, int length) {
        if (payload != null && length >= 0) {
            for (int i = 0; i < Math.min(length, payload.length); ++i) {
                if (payload[i] != 11) continue;
                return i;
            }
        }
        return -1;
    }

    public static int findEndOfMessage(byte[] payload) {
        if (payload != null) {
            return MllpSocketUtil.findEndOfMessage(payload, payload.length);
        }
        return -1;
    }

    public static int findEndOfMessage(byte[] payload, int length) {
        if (payload != null && length >= 0) {
            for (int i = Math.min(length, payload.length) - 1; i > 0; --i) {
                if (payload[i] != 13 || i <= 0 || payload[i - 1] != 28) continue;
                return i - 1;
            }
        }
        return -1;
    }
}

