/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.apache.camel.component.mongodb.MongoDBTailTrackingStrategy;
import org.bson.types.BSONTimestamp;

public enum MongoDBTailTrackingEnum implements MongoDBTailTrackingStrategy
{
    TIMESTAMP{

        @Override
        public Object extractLastVal(DBObject o, String increasingField) {
            Object temp = o.get(increasingField);
            return ((BSONTimestamp)temp).getTime();
        }

        @Override
        public BasicDBObject createQuery(Object lastVal, String increasingField) {
            return new BasicDBObject(increasingField, (Object)new BasicDBObject("$gt", (Object)new BSONTimestamp(((Integer)lastVal).intValue(), 1)));
        }
    }
    ,
    LITERAL{

        @Override
        public Object extractLastVal(DBObject o, String increasingField) {
            return o.get(increasingField);
        }

        @Override
        public BasicDBObject createQuery(Object lastVal, String increasingField) {
            return new BasicDBObject(increasingField, (Object)new BasicDBObject("$gt", lastVal));
        }
    };

}

