/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy;

import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.proxy.ProxyAnnotationException;
import com.netflix.ribbon.proxy.RibbonProxyException;
import com.netflix.ribbon.proxy.annotation.ResourceGroup;

class ClassTemplate<T> {
    private final Class<T> clientInterface;
    private final String resourceGroupName;
    private final Class<? extends HttpResourceGroup> resourceGroupClass;

    ClassTemplate(Class<T> clientInterface) {
        this.clientInterface = clientInterface;
        ResourceGroup annotation = clientInterface.getAnnotation(ResourceGroup.class);
        if (annotation != null) {
            String name = annotation.name().trim();
            String string = this.resourceGroupName = name.isEmpty() ? null : annotation.name();
            if (annotation.resourceGroupClass().length == 0) {
                this.resourceGroupClass = null;
            } else if (annotation.resourceGroupClass().length == 1) {
                this.resourceGroupClass = annotation.resourceGroupClass()[0];
            } else {
                throw new ProxyAnnotationException("only one resource group may be defined with @ResourceGroup annotation");
            }
            this.verify();
        } else {
            this.resourceGroupName = null;
            this.resourceGroupClass = null;
        }
    }

    public Class<T> getClientInterface() {
        return this.clientInterface;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public Class<? extends HttpResourceGroup> getResourceGroupClass() {
        return this.resourceGroupClass;
    }

    public static <T> ClassTemplate<T> from(Class<T> clientInterface) {
        return new ClassTemplate<T>(clientInterface);
    }

    private void verify() {
        if (this.resourceGroupName != null && this.resourceGroupClass != null) {
            throw new RibbonProxyException("Both resource group name and class defined with @ResourceGroup");
        }
    }
}

