/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy;

import com.netflix.client.config.ClientConfigFactory;
import com.netflix.ribbon.DefaultResourceFactory;
import com.netflix.ribbon.RibbonResourceFactory;
import com.netflix.ribbon.RibbonTransportFactory;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.proxy.ClassTemplate;
import com.netflix.ribbon.proxy.Utils;
import com.netflix.ribbon.proxy.processor.AnnotationProcessor;
import com.netflix.ribbon.proxy.processor.AnnotationProcessorsProvider;

public class ProxyHttpResourceGroupFactory<T> {
    private final ClassTemplate<T> classTemplate;
    private final RibbonResourceFactory httpResourceGroupFactory;
    private final AnnotationProcessorsProvider processors;

    ProxyHttpResourceGroupFactory(ClassTemplate<T> classTemplate) {
        this(classTemplate, new DefaultResourceFactory(ClientConfigFactory.DEFAULT, RibbonTransportFactory.DEFAULT, AnnotationProcessorsProvider.DEFAULT), AnnotationProcessorsProvider.DEFAULT);
    }

    ProxyHttpResourceGroupFactory(ClassTemplate<T> classTemplate, RibbonResourceFactory httpResourceGroupFactory, AnnotationProcessorsProvider processors) {
        this.classTemplate = classTemplate;
        this.httpResourceGroupFactory = httpResourceGroupFactory;
        this.processors = processors;
    }

    public HttpResourceGroup createResourceGroup() {
        Class<HttpResourceGroup> resourceClass = this.classTemplate.getResourceGroupClass();
        if (resourceClass != null) {
            return Utils.newInstance(resourceClass);
        }
        String name = this.classTemplate.getResourceGroupName();
        if (name == null) {
            name = this.classTemplate.getClientInterface().getSimpleName();
        }
        HttpResourceGroup.Builder builder = this.httpResourceGroupFactory.createHttpResourceGroupBuilder(name);
        for (AnnotationProcessor processor : this.processors.getProcessors()) {
            processor.process(name, builder, this.httpResourceGroupFactory, this.classTemplate.getClientInterface());
        }
        return builder.build();
    }
}

