/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ec2;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ec2.EC2Configuration;
import org.apache.camel.component.aws.ec2.EC2Endpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class EC2Component
extends UriEndpointComponent {
    public EC2Component() {
        super(EC2Endpoint.class);
    }

    public EC2Component(CamelContext context) {
        super(context, EC2Endpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EC2Configuration configuration = new EC2Configuration();
        this.setProperties(configuration, parameters);
        if (configuration.getAmazonEc2Client() == null) {
            throw new IllegalArgumentException("amazonEC2Client must be specified");
        }
        EC2Endpoint endpoint = new EC2Endpoint(uri, (Component)this, configuration);
        return endpoint;
    }
}

