/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class S3Component
extends UriEndpointComponent {
    public S3Component() {
        super(S3Endpoint.class);
    }

    public S3Component(CamelContext context) {
        super(context, S3Endpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        S3Configuration configuration = new S3Configuration();
        this.setProperties(configuration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Bucket name must be specified.");
        }
        if (remaining.startsWith("arn:")) {
            remaining = remaining.substring(remaining.lastIndexOf(":") + 1, remaining.length());
        }
        configuration.setBucketName(remaining);
        if (configuration.getAmazonS3Client() == null) {
            throw new IllegalArgumentException("AmazonS3Client must be specified");
        }
        S3Endpoint endpoint = new S3Endpoint(uri, (Component)this, configuration);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }
}

