/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.build;

import com.openshift.internal.restclient.model.BuildConfig;
import com.openshift.internal.restclient.model.build.GitBuildSource;
import com.openshift.internal.restclient.model.build.ImageChangeTrigger;
import com.openshift.internal.restclient.model.build.JenkinsPipelineStrategy;
import com.openshift.internal.restclient.model.build.SourceBuildStrategy;
import com.openshift.internal.restclient.model.build.WebhookTrigger;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IEnvironmentVariable;
import com.openshift.restclient.model.IObjectReference;
import com.openshift.restclient.model.build.IBuildConfigBuilder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class BuildConfigBuilder
implements IBuildConfigBuilder {
    private SourceStrategyBuilder sourceStrategyBuilder;
    private GitSourceBuilder gitSourceBuilder;
    private JenkinsPipelineStrategyBuilder jenkinsPipelineStrategyBuilder;
    private String imageStreamTagOutput;
    private boolean buildOnConfigChange;
    private boolean buildOnImageChange;
    private boolean buildOnSourceChange;
    private final IClient client;
    private String name;
    private String namespace;
    private Map<String, String> labels;

    public BuildConfigBuilder(IClient client) {
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return BuildConfigBuilder.class.getSimpleName();
    }

    @Override
    public IBuildConfigBuilder named(String name) {
        this.name = name;
        return this;
    }

    @Override
    public IBuildConfigBuilder inNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public IBuildConfigBuilder withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public IBuildConfig build() {
        BuildConfig bc = (BuildConfig)this.client.getResourceFactory().stub("BuildConfig", this.name, this.namespace);
        if (this.sourceStrategyBuilder != null) {
            bc.setBuildStrategy(this.sourceStrategyBuilder.build(bc.getPropertyKeys()));
        } else if (this.jenkinsPipelineStrategyBuilder != null) {
            bc.setBuildStrategy(this.jenkinsPipelineStrategyBuilder.build(bc.getPropertyKeys()));
        }
        if (this.gitSourceBuilder != null) {
            bc.setBuildSource(this.gitSourceBuilder.build());
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            for (Map.Entry<String, String> label : this.labels.entrySet()) {
                bc.addLabel(label.getKey(), label.getValue());
            }
        }
        DockerImageURI uri = new DockerImageURI(this.imageStreamTagOutput);
        IObjectReference outRef = bc.getBuildOutputReference();
        outRef.setKind("ImageStreamTag");
        outRef.setName(uri.getNameAndTag());
        if (StringUtils.isNotBlank((String)uri.getUserName())) {
            outRef.setNamespace(uri.getUserName());
        }
        bc.addBuildTrigger(new WebhookTrigger("Generic", UUID.randomUUID().toString(), null));
        if (this.buildOnImageChange) {
            bc.addBuildTrigger(new ImageChangeTrigger("ImageChange", null, null, null));
        }
        if (this.buildOnConfigChange) {
            bc.addBuildTrigger(new ImageChangeTrigger("ConfigChange", null, null, null));
        }
        if (this.buildOnSourceChange) {
            bc.addBuildTrigger(new WebhookTrigger("GitHub", UUID.randomUUID().toString(), null));
        }
        return bc;
    }

    @Override
    public IBuildConfigBuilder buildOnSourceChange(boolean onSourceChange) {
        this.buildOnSourceChange = onSourceChange;
        return this;
    }

    @Override
    public IBuildConfigBuilder buildOnImageChange(boolean onImageChange) {
        this.buildOnImageChange = onImageChange;
        return this;
    }

    @Override
    public IBuildConfigBuilder buildOnConfigChange(boolean onConfigChange) {
        this.buildOnConfigChange = onConfigChange;
        return this;
    }

    @Override
    public IBuildConfigBuilder toImageStreamTag(String tag) {
        this.imageStreamTagOutput = tag;
        return this;
    }

    @Override
    public IBuildConfigBuilder.ISourceStrategyBuilder usingSourceStrategy() {
        this.sourceStrategyBuilder = new SourceStrategyBuilder(this);
        return this.sourceStrategyBuilder;
    }

    @Override
    public IBuildConfigBuilder.IGitSourceBuilder fromGitSource() {
        this.gitSourceBuilder = new GitSourceBuilder(this);
        return this.gitSourceBuilder;
    }

    @Override
    public IBuildConfigBuilder.IJenkinsPipelineStrategyBuilder usingJenkinsPipelineStrategy() {
        this.jenkinsPipelineStrategyBuilder = new JenkinsPipelineStrategyBuilder(this);
        return this.jenkinsPipelineStrategyBuilder;
    }

    class JenkinsPipelineStrategyBuilder
    implements IBuildConfigBuilder.IJenkinsPipelineStrategyBuilder {
        private IBuildConfigBuilder builder;
        private String jenkinsFilePath;
        private String jenkinsFile;

        JenkinsPipelineStrategyBuilder(IBuildConfigBuilder builder) {
            this.builder = builder;
        }

        @Override
        public IBuildConfigBuilder.IJenkinsPipelineStrategyBuilder usingFile(String file) {
            this.jenkinsFile = file;
            return this;
        }

        @Override
        public IBuildConfigBuilder.IJenkinsPipelineStrategyBuilder usingFilePath(String filePath) {
            this.jenkinsFilePath = filePath;
            return this;
        }

        private JenkinsPipelineStrategy build(Map<String, String[]> overrides) {
            JenkinsPipelineStrategy strategy = new JenkinsPipelineStrategy(new ModelNode(), overrides);
            strategy.setJenkinsfilePath(this.jenkinsFilePath);
            strategy.setJenkinsfile(this.jenkinsFile);
            return strategy;
        }

        @Override
        public IBuildConfigBuilder end() {
            return this.builder;
        }
    }

    class SourceStrategyBuilder
    implements IBuildConfigBuilder.ISourceStrategyBuilder {
        private IBuildConfigBuilder builder;
        private List<IEnvironmentVariable> envVars;
        private String namespace;
        private String tag;
        private String fromKind;

        SourceStrategyBuilder(IBuildConfigBuilder builder) {
            this.builder = builder;
        }

        public SourceBuildStrategy build(Map<String, String[]> overrides) {
            SourceBuildStrategy strategy = new SourceBuildStrategy(new ModelNode(), overrides);
            strategy.setEnvVars(this.envVars);
            strategy.setFromNamespace(this.namespace);
            strategy.setImage(new DockerImageURI(this.tag));
            strategy.setFromKind(this.fromKind);
            return strategy;
        }

        @Override
        public IBuildConfigBuilder end() {
            return this.builder;
        }

        @Override
        public IBuildConfigBuilder.ISourceStrategyBuilder fromImageStreamTag(String tag) {
            this.tag = tag;
            this.fromKind = "ImageStreamTag";
            return this;
        }

        @Override
        public IBuildConfigBuilder.ISourceStrategyBuilder inNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public IBuildConfigBuilder.ISourceStrategyBuilder withEnvVars(List<IEnvironmentVariable> envVars) {
            this.envVars = envVars;
            return this;
        }

        @Override
        public IBuildConfigBuilder.ISourceStrategyBuilder fromDockerImage(String tag) {
            this.tag = tag;
            this.fromKind = "DockerImage";
            return this;
        }
    }

    class GitSourceBuilder
    implements IBuildConfigBuilder.IGitSourceBuilder {
        private IBuildConfigBuilder builder;
        private String url;
        private String ref;
        private String contextDir;

        GitSourceBuilder(IBuildConfigBuilder builder) {
            this.builder = builder;
        }

        private GitBuildSource build() {
            return new GitBuildSource(this.url, this.ref, this.contextDir);
        }

        @Override
        public IBuildConfigBuilder end() {
            return this.builder;
        }

        @Override
        public IBuildConfigBuilder.IGitSourceBuilder fromGitUrl(String url) {
            this.url = url;
            return this;
        }

        @Override
        public IBuildConfigBuilder.IGitSourceBuilder usingGitReference(String ref) {
            this.ref = ref;
            return this;
        }

        @Override
        public IBuildConfigBuilder.IGitSourceBuilder inContextDir(String contextDir) {
            this.contextDir = contextDir;
            return this;
        }
    }
}

