/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.neo4jdriver;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.neo4jdriver.neo4j.Host;
import org.wildfly.swarm.config.neo4jdriver.neo4j.HostConsumer;
import org.wildfly.swarm.config.neo4jdriver.neo4j.HostSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=neo4jdriver/neo4j=*")
@ResourceType(value="neo4j")
public class Neo4j<T extends Neo4j<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private Neo4jResources subresources = new Neo4jResources();
    @AttributeDocumentation(value="Unique profile identification")
    private String id;
    @AttributeDocumentation(value="JNDI address")
    private String jndiName;
    @AttributeDocumentation(value="Module name")
    private String module;
    @AttributeDocumentation(value="Security domain name")
    private String securityDomain;
    @AttributeDocumentation(value="Transaction enlistment (none or 1pc)")
    private String transaction;

    public Neo4j(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public Neo4jResources subresources() {
        return this.subresources;
    }

    public T hosts(List<Host> value) {
        this.subresources.hosts = value;
        return (T)this;
    }

    public T host(Host value) {
        this.subresources.hosts.add(value);
        return (T)this;
    }

    public T host(String childKey, HostConsumer consumer) {
        Host child = new Host(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.host(child);
        return (T)this;
    }

    public T host(String childKey) {
        this.host(childKey, null);
        return (T)this;
    }

    public T host(HostSupplier supplier) {
        this.host(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="id")
    public String id() {
        return this.id;
    }

    public T id(String value) {
        String oldValue = this.id;
        this.id = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("id", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction")
    public String transaction() {
        return this.transaction;
    }

    public T transaction(String value) {
        String oldValue = this.transaction;
        this.transaction = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transaction", oldValue, value);
        }
        return (T)this;
    }

    public static class Neo4jResources {
        @ResourceDocumentation(value="Host")
        @SubresourceInfo(value="host")
        private List<Host> hosts = new ArrayList<Host>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        public Host host(String key) {
            return this.hosts.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

