/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.consumer;

import com.dropbox.core.DbxEntry;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.integration.consumer.DropboxScheduledPollConsumer;
import org.apache.camel.component.dropbox.util.DropboxResultHeader;

public class DropboxScheduledPollSearchConsumer
extends DropboxScheduledPollConsumer {
    public DropboxScheduledPollSearchConsumer(DropboxEndpoint endpoint, Processor processor, DropboxConfiguration configuration) {
        super(endpoint, processor, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int poll() throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        DropboxSearchResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).search(this.configuration.getRemotePath(), this.configuration.getQuery());
        StringBuilder fileExtracted = new StringBuilder();
        for (DbxEntry entry : result.getFound()) {
            fileExtracted.append(entry.name).append("-").append(entry.path).append("\n");
        }
        exchange.getIn().setHeader(DropboxResultHeader.FOUND_FILES.name(), (Object)fileExtracted.toString());
        exchange.getIn().setBody(result.getFound());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Downloaded: {}", (Object)result.toString());
        }
        try {
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

