/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cloud;

import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryFactory;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.cloud.KubernetesClientServiceDiscovery;
import org.apache.camel.component.kubernetes.cloud.KubernetesDnsServiceDiscovery;
import org.apache.camel.component.kubernetes.cloud.KubernetesEnvServiceDiscovery;
import org.apache.camel.util.ObjectHelper;

public class KubernetesServiceDiscoveryFactory
implements ServiceDiscoveryFactory {
    private final KubernetesConfiguration configuration;
    private String lookup;

    public KubernetesServiceDiscoveryFactory() {
        this(new KubernetesConfiguration());
    }

    public KubernetesServiceDiscoveryFactory(KubernetesConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getMasterUrl() {
        return this.configuration.getMasterUrl();
    }

    public void setMasterUrl(String masterUrl) {
        this.configuration.setMasterUrl(masterUrl);
    }

    public String getUsername() {
        return this.configuration.getUsername();
    }

    public void setUsername(String username) {
        this.configuration.setUsername(username);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public String getApiVersion() {
        return this.configuration.getApiVersion();
    }

    public void setApiVersion(String apiVersion) {
        this.configuration.setApiVersion(apiVersion);
    }

    public String getCaCertData() {
        return this.configuration.getCaCertData();
    }

    public void setCaCertData(String caCertData) {
        this.configuration.setCaCertData(caCertData);
    }

    public String getCaCertFile() {
        return this.configuration.getCaCertFile();
    }

    public void setCaCertFile(String caCertFile) {
        this.configuration.setCaCertFile(caCertFile);
    }

    public String getClientCertData() {
        return this.configuration.getClientCertData();
    }

    public void setClientCertData(String clientCertData) {
        this.configuration.setClientCertData(clientCertData);
    }

    public String getClientCertFile() {
        return this.configuration.getClientCertFile();
    }

    public void setClientCertFile(String clientCertFile) {
        this.configuration.setClientCertFile(clientCertFile);
    }

    public String getClientKeyAlgo() {
        return this.configuration.getClientKeyAlgo();
    }

    public void setClientKeyAlgo(String clientKeyAlgo) {
        this.configuration.setClientKeyAlgo(clientKeyAlgo);
    }

    public String getClientKeyData() {
        return this.configuration.getClientKeyData();
    }

    public void setClientKeyData(String clientKeyData) {
        this.configuration.setClientKeyData(clientKeyData);
    }

    public String getClientKeyFile() {
        return this.configuration.getClientKeyFile();
    }

    public void setClientKeyFile(String clientKeyFile) {
        this.configuration.setClientKeyFile(clientKeyFile);
    }

    public String getClientKeyPassphrase() {
        return this.configuration.getClientKeyPassphrase();
    }

    public void setClientKeyPassphrase(String clientKeyPassphrase) {
        this.configuration.setClientKeyPassphrase(clientKeyPassphrase);
    }

    public String getOauthToken() {
        return this.configuration.getOauthToken();
    }

    public void setOauthToken(String oauthToken) {
        this.configuration.setOauthToken(oauthToken);
    }

    public Boolean getTrustCerts() {
        return this.configuration.getTrustCerts();
    }

    public void setTrustCerts(Boolean trustCerts) {
        this.configuration.setTrustCerts(trustCerts);
    }

    public String getNamespace() {
        return this.configuration.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.configuration.setNamespace(namespace);
    }

    public String getDnsDomain() {
        return this.configuration.getDnsDomain();
    }

    public void setDnsDomain(String dnsDomain) {
        this.configuration.setDnsDomain(dnsDomain);
    }

    public String getLookup() {
        return this.lookup;
    }

    public void setLookup(String lookup) {
        this.lookup = lookup;
    }

    public ServiceDiscovery newInstance(CamelContext camelContext) throws Exception {
        if (ObjectHelper.equal((Object)"dns", (Object)this.lookup)) {
            return new KubernetesDnsServiceDiscovery(this.configuration);
        }
        if (ObjectHelper.equal((Object)"client", (Object)this.lookup)) {
            return new KubernetesClientServiceDiscovery(this.configuration);
        }
        return new KubernetesEnvServiceDiscovery(this.configuration);
    }
}

