/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.management.AuditAccess;
import org.wildfly.swarm.config.management.AuditAccessConsumer;
import org.wildfly.swarm.config.management.AuditAccessSupplier;
import org.wildfly.swarm.config.management.AuthorizationAccess;
import org.wildfly.swarm.config.management.AuthorizationAccessConsumer;
import org.wildfly.swarm.config.management.AuthorizationAccessSupplier;
import org.wildfly.swarm.config.management.ConfigurationChangesService;
import org.wildfly.swarm.config.management.ConfigurationChangesServiceConsumer;
import org.wildfly.swarm.config.management.ConfigurationChangesServiceSupplier;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterface;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceSupplier;
import org.wildfly.swarm.config.management.LdapConnection;
import org.wildfly.swarm.config.management.LdapConnectionConsumer;
import org.wildfly.swarm.config.management.LdapConnectionSupplier;
import org.wildfly.swarm.config.management.ManagementOperationsService;
import org.wildfly.swarm.config.management.ManagementOperationsServiceConsumer;
import org.wildfly.swarm.config.management.ManagementOperationsServiceSupplier;
import org.wildfly.swarm.config.management.NativeInterfaceManagementInterface;
import org.wildfly.swarm.config.management.NativeInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.config.management.NativeInterfaceManagementInterfaceSupplier;
import org.wildfly.swarm.config.management.NativeRemotingInterfaceManagementInterface;
import org.wildfly.swarm.config.management.NativeRemotingInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.config.management.NativeRemotingInterfaceManagementInterfaceSupplier;
import org.wildfly.swarm.config.management.SecurityRealm;
import org.wildfly.swarm.config.management.SecurityRealmConsumer;
import org.wildfly.swarm.config.management.SecurityRealmSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/core-service=management")
@ResourceType(value="core-service")
@Implicit
public class ManagementCoreService<T extends ManagementCoreService<T>>
extends HashMap
implements Keyed {
    private String key = "management";
    private PropertyChangeSupport pcs;
    private ManagementCoreServiceResources subresources = new ManagementCoreServiceResources();

    public ManagementCoreService() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ManagementCoreServiceResources subresources() {
        return this.subresources;
    }

    public T securityRealms(List<SecurityRealm> value) {
        this.subresources.securityRealms = value;
        return (T)this;
    }

    public T securityRealm(SecurityRealm value) {
        this.subresources.securityRealms.add(value);
        return (T)this;
    }

    public T securityRealm(String childKey, SecurityRealmConsumer consumer) {
        SecurityRealm child = new SecurityRealm(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.securityRealm(child);
        return (T)this;
    }

    public T securityRealm(String childKey) {
        this.securityRealm(childKey, null);
        return (T)this;
    }

    public T securityRealm(SecurityRealmSupplier supplier) {
        this.securityRealm(supplier.get());
        return (T)this;
    }

    public T ldapConnections(List<LdapConnection> value) {
        this.subresources.ldapConnections = value;
        return (T)this;
    }

    public T ldapConnection(LdapConnection value) {
        this.subresources.ldapConnections.add(value);
        return (T)this;
    }

    public T ldapConnection(String childKey, LdapConnectionConsumer consumer) {
        LdapConnection child = new LdapConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.ldapConnection(child);
        return (T)this;
    }

    public T ldapConnection(String childKey) {
        this.ldapConnection(childKey, null);
        return (T)this;
    }

    public T ldapConnection(LdapConnectionSupplier supplier) {
        this.ldapConnection(supplier.get());
        return (T)this;
    }

    public T nativeRemotingInterfaceManagementInterface(NativeRemotingInterfaceManagementInterface value) {
        this.subresources.nativeRemotingInterfaceManagementInterface = value;
        return (T)this;
    }

    public T nativeRemotingInterfaceManagementInterface(NativeRemotingInterfaceManagementInterfaceConsumer consumer) {
        NativeRemotingInterfaceManagementInterface child = new NativeRemotingInterfaceManagementInterface();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.nativeRemotingInterfaceManagementInterface = child;
        return (T)this;
    }

    public T nativeRemotingInterfaceManagementInterface() {
        NativeRemotingInterfaceManagementInterface child = new NativeRemotingInterfaceManagementInterface();
        this.subresources.nativeRemotingInterfaceManagementInterface = child;
        return (T)this;
    }

    public T nativeRemotingInterfaceManagementInterface(NativeRemotingInterfaceManagementInterfaceSupplier supplier) {
        this.subresources.nativeRemotingInterfaceManagementInterface = supplier.get();
        return (T)this;
    }

    public T auditAccess(AuditAccess value) {
        this.subresources.auditAccess = value;
        return (T)this;
    }

    public T auditAccess(AuditAccessConsumer consumer) {
        AuditAccess child = new AuditAccess();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.auditAccess = child;
        return (T)this;
    }

    public T auditAccess() {
        AuditAccess child = new AuditAccess();
        this.subresources.auditAccess = child;
        return (T)this;
    }

    public T auditAccess(AuditAccessSupplier supplier) {
        this.subresources.auditAccess = supplier.get();
        return (T)this;
    }

    public T nativeInterfaceManagementInterface(NativeInterfaceManagementInterface value) {
        this.subresources.nativeInterfaceManagementInterface = value;
        return (T)this;
    }

    public T nativeInterfaceManagementInterface(NativeInterfaceManagementInterfaceConsumer consumer) {
        NativeInterfaceManagementInterface child = new NativeInterfaceManagementInterface();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.nativeInterfaceManagementInterface = child;
        return (T)this;
    }

    public T nativeInterfaceManagementInterface() {
        NativeInterfaceManagementInterface child = new NativeInterfaceManagementInterface();
        this.subresources.nativeInterfaceManagementInterface = child;
        return (T)this;
    }

    public T nativeInterfaceManagementInterface(NativeInterfaceManagementInterfaceSupplier supplier) {
        this.subresources.nativeInterfaceManagementInterface = supplier.get();
        return (T)this;
    }

    public T managementOperationsService(ManagementOperationsService value) {
        this.subresources.managementOperationsService = value;
        return (T)this;
    }

    public T managementOperationsService(ManagementOperationsServiceConsumer consumer) {
        ManagementOperationsService child = new ManagementOperationsService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.managementOperationsService = child;
        return (T)this;
    }

    public T managementOperationsService() {
        ManagementOperationsService child = new ManagementOperationsService();
        this.subresources.managementOperationsService = child;
        return (T)this;
    }

    public T managementOperationsService(ManagementOperationsServiceSupplier supplier) {
        this.subresources.managementOperationsService = supplier.get();
        return (T)this;
    }

    public T configurationChangesService(ConfigurationChangesService value) {
        this.subresources.configurationChangesService = value;
        return (T)this;
    }

    public T configurationChangesService(ConfigurationChangesServiceConsumer consumer) {
        ConfigurationChangesService child = new ConfigurationChangesService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.configurationChangesService = child;
        return (T)this;
    }

    public T configurationChangesService() {
        ConfigurationChangesService child = new ConfigurationChangesService();
        this.subresources.configurationChangesService = child;
        return (T)this;
    }

    public T configurationChangesService(ConfigurationChangesServiceSupplier supplier) {
        this.subresources.configurationChangesService = supplier.get();
        return (T)this;
    }

    public T httpInterfaceManagementInterface(HTTPInterfaceManagementInterface value) {
        this.subresources.httpInterfaceManagementInterface = value;
        return (T)this;
    }

    public T httpInterfaceManagementInterface(HTTPInterfaceManagementInterfaceConsumer consumer) {
        HTTPInterfaceManagementInterface child = new HTTPInterfaceManagementInterface();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.httpInterfaceManagementInterface = child;
        return (T)this;
    }

    public T httpInterfaceManagementInterface() {
        HTTPInterfaceManagementInterface child = new HTTPInterfaceManagementInterface();
        this.subresources.httpInterfaceManagementInterface = child;
        return (T)this;
    }

    public T httpInterfaceManagementInterface(HTTPInterfaceManagementInterfaceSupplier supplier) {
        this.subresources.httpInterfaceManagementInterface = supplier.get();
        return (T)this;
    }

    public T authorizationAccess(AuthorizationAccess value) {
        this.subresources.authorizationAccess = value;
        return (T)this;
    }

    public T authorizationAccess(AuthorizationAccessConsumer consumer) {
        AuthorizationAccess child = new AuthorizationAccess();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.authorizationAccess = child;
        return (T)this;
    }

    public T authorizationAccess() {
        AuthorizationAccess child = new AuthorizationAccess();
        this.subresources.authorizationAccess = child;
        return (T)this;
    }

    public T authorizationAccess(AuthorizationAccessSupplier supplier) {
        this.subresources.authorizationAccess = supplier.get();
        return (T)this;
    }

    public static class ManagementCoreServiceResources {
        @ResourceDocumentation(value="A security realm that can be associated with a management interface and used to control access to the management services.")
        @SubresourceInfo(value="securityRealm")
        private List<SecurityRealm> securityRealms = new ArrayList<SecurityRealm>();
        @ResourceDocumentation(value="A connection factory that can be used by a security realm to access an LDAP server as a source of authentication and authorization information.")
        @SubresourceInfo(value="ldapConnection")
        private List<LdapConnection> ldapConnections = new ArrayList<LdapConnection>();
        @SingletonResource
        @ResourceDocumentation(value="Configuration of the server's native management interface using a connector from the remoting subsystem.")
        private NativeRemotingInterfaceManagementInterface nativeRemotingInterfaceManagementInterface;
        @SingletonResource
        @ResourceDocumentation(value="The management audit logging top-level resource.")
        private AuditAccess auditAccess;
        @SingletonResource
        @ResourceDocumentation(value="Configuration of the server's native management interface")
        private NativeInterfaceManagementInterface nativeInterfaceManagementInterface;
        @SingletonResource
        @ResourceDocumentation(value="Execution of management operations.")
        private ManagementOperationsService managementOperationsService;
        @SingletonResource
        @ResourceDocumentation(value="Service to store and list configuration changes.")
        private ConfigurationChangesService configurationChangesService;
        @SingletonResource
        @ResourceDocumentation(value="Configuration of the server's HTTP management interface")
        private HTTPInterfaceManagementInterface httpInterfaceManagementInterface;
        @SingletonResource
        @ResourceDocumentation(value="The access control definitions defining the access management restrictions.")
        private AuthorizationAccess authorizationAccess;

        @Subresource
        public List<SecurityRealm> securityRealms() {
            return this.securityRealms;
        }

        public SecurityRealm securityRealm(String key) {
            return this.securityRealms.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<LdapConnection> ldapConnections() {
            return this.ldapConnections;
        }

        public LdapConnection ldapConnection(String key) {
            return this.ldapConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public NativeRemotingInterfaceManagementInterface nativeRemotingInterfaceManagementInterface() {
            return this.nativeRemotingInterfaceManagementInterface;
        }

        @Subresource
        public AuditAccess auditAccess() {
            return this.auditAccess;
        }

        @Subresource
        public NativeInterfaceManagementInterface nativeInterfaceManagementInterface() {
            return this.nativeInterfaceManagementInterface;
        }

        @Subresource
        public ManagementOperationsService managementOperationsService() {
            return this.managementOperationsService;
        }

        @Subresource
        public ConfigurationChangesService configurationChangesService() {
            return this.configurationChangesService;
        }

        @Subresource
        public HTTPInterfaceManagementInterface httpInterfaceManagementInterface() {
            return this.httpInterfaceManagementInterface;
        }

        @Subresource
        public AuthorizationAccess authorizationAccess() {
            return this.authorizationAccess;
        }
    }
}

