/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.BufferCache;
import org.wildfly.swarm.config.undertow.BufferCacheConsumer;
import org.wildfly.swarm.config.undertow.BufferCacheSupplier;
import org.wildfly.swarm.config.undertow.FilterConfiguration;
import org.wildfly.swarm.config.undertow.FilterConfigurationConsumer;
import org.wildfly.swarm.config.undertow.FilterConfigurationSupplier;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.HandlerConfigurationConsumer;
import org.wildfly.swarm.config.undertow.HandlerConfigurationSupplier;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.ServerConsumer;
import org.wildfly.swarm.config.undertow.ServerSupplier;
import org.wildfly.swarm.config.undertow.ServletContainer;
import org.wildfly.swarm.config.undertow.ServletContainerConsumer;
import org.wildfly.swarm.config.undertow.ServletContainerSupplier;

@Address(value="/subsystem=undertow")
@ResourceType(value="subsystem")
@Implicit
public class Undertow<T extends Undertow<T>>
extends HashMap
implements Keyed {
    private String key = "undertow";
    private PropertyChangeSupport pcs;
    private UndertowResources subresources = new UndertowResources();
    @AttributeDocumentation(value="The default security domain used by web deployments")
    private String defaultSecurityDomain;
    @AttributeDocumentation(value="The default server to use for deployments")
    private String defaultServer;
    @AttributeDocumentation(value="The default servlet container to use for deployments")
    private String defaultServletContainer;
    @AttributeDocumentation(value="The default virtual host to use for deployments")
    private String defaultVirtualHost;
    @AttributeDocumentation(value="The cluster instance id")
    private String instanceId;
    @AttributeDocumentation(value="Configures if statistics are enabled")
    private Boolean statisticsEnabled;

    public Undertow() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public UndertowResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers = value;
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConsumer consumer) {
        Server child = new Server(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.server(child);
        return (T)this;
    }

    public T server(String childKey) {
        this.server(childKey, null);
        return (T)this;
    }

    public T server(ServerSupplier supplier) {
        this.server(supplier.get());
        return (T)this;
    }

    public T bufferCaches(List<BufferCache> value) {
        this.subresources.bufferCaches = value;
        return (T)this;
    }

    public T bufferCache(BufferCache value) {
        this.subresources.bufferCaches.add(value);
        return (T)this;
    }

    public T bufferCache(String childKey, BufferCacheConsumer consumer) {
        BufferCache child = new BufferCache(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.bufferCache(child);
        return (T)this;
    }

    public T bufferCache(String childKey) {
        this.bufferCache(childKey, null);
        return (T)this;
    }

    public T bufferCache(BufferCacheSupplier supplier) {
        this.bufferCache(supplier.get());
        return (T)this;
    }

    public T servletContainers(List<ServletContainer> value) {
        this.subresources.servletContainers = value;
        return (T)this;
    }

    public T servletContainer(ServletContainer value) {
        this.subresources.servletContainers.add(value);
        return (T)this;
    }

    public T servletContainer(String childKey, ServletContainerConsumer consumer) {
        ServletContainer child = new ServletContainer(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.servletContainer(child);
        return (T)this;
    }

    public T servletContainer(String childKey) {
        this.servletContainer(childKey, null);
        return (T)this;
    }

    public T servletContainer(ServletContainerSupplier supplier) {
        this.servletContainer(supplier.get());
        return (T)this;
    }

    public T handlerConfiguration(HandlerConfiguration value) {
        this.subresources.handlerConfiguration = value;
        return (T)this;
    }

    public T handlerConfiguration(HandlerConfigurationConsumer consumer) {
        HandlerConfiguration child = new HandlerConfiguration();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.handlerConfiguration = child;
        return (T)this;
    }

    public T handlerConfiguration() {
        HandlerConfiguration child = new HandlerConfiguration();
        this.subresources.handlerConfiguration = child;
        return (T)this;
    }

    public T handlerConfiguration(HandlerConfigurationSupplier supplier) {
        this.subresources.handlerConfiguration = supplier.get();
        return (T)this;
    }

    public T filterConfiguration(FilterConfiguration value) {
        this.subresources.filterConfiguration = value;
        return (T)this;
    }

    public T filterConfiguration(FilterConfigurationConsumer consumer) {
        FilterConfiguration child = new FilterConfiguration();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.filterConfiguration = child;
        return (T)this;
    }

    public T filterConfiguration() {
        FilterConfiguration child = new FilterConfiguration();
        this.subresources.filterConfiguration = child;
        return (T)this;
    }

    public T filterConfiguration(FilterConfigurationSupplier supplier) {
        this.subresources.filterConfiguration = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-security-domain")
    public String defaultSecurityDomain() {
        return this.defaultSecurityDomain;
    }

    public T defaultSecurityDomain(String value) {
        String oldValue = this.defaultSecurityDomain;
        this.defaultSecurityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSecurityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-server")
    public String defaultServer() {
        return this.defaultServer;
    }

    public T defaultServer(String value) {
        String oldValue = this.defaultServer;
        this.defaultServer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultServer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-servlet-container")
    public String defaultServletContainer() {
        return this.defaultServletContainer;
    }

    public T defaultServletContainer(String value) {
        String oldValue = this.defaultServletContainer;
        this.defaultServletContainer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultServletContainer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-virtual-host")
    public String defaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public T defaultVirtualHost(String value) {
        String oldValue = this.defaultVirtualHost;
        this.defaultVirtualHost = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultVirtualHost", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="instance-id")
    public String instanceId() {
        return this.instanceId;
    }

    public T instanceId(String value) {
        String oldValue = this.instanceId;
        this.instanceId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("instanceId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    public static class UndertowResources {
        @ResourceDocumentation(value="A server")
        @SubresourceInfo(value="server")
        private List<Server> servers = new ArrayList<Server>();
        @ResourceDocumentation(value="The buffer cache used to cache static content")
        @SubresourceInfo(value="bufferCache")
        private List<BufferCache> bufferCaches = new ArrayList<BufferCache>();
        @ResourceDocumentation(value="A servlet container")
        @SubresourceInfo(value="servletContainer")
        private List<ServletContainer> servletContainers = new ArrayList<ServletContainer>();
        @SingletonResource
        @ResourceDocumentation(value="Undertow handlers")
        private HandlerConfiguration handlerConfiguration;
        @SingletonResource
        @ResourceDocumentation(value="Undertow filters")
        private FilterConfiguration filterConfiguration;

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        public Server server(String key) {
            return this.servers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<BufferCache> bufferCaches() {
            return this.bufferCaches;
        }

        public BufferCache bufferCache(String key) {
            return this.bufferCaches.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ServletContainer> servletContainers() {
            return this.servletContainers;
        }

        public ServletContainer servletContainer(String key) {
            return this.servletContainers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public HandlerConfiguration handlerConfiguration() {
            return this.handlerConfiguration;
        }

        @Subresource
        public FilterConfiguration filterConfiguration() {
            return this.filterConfiguration;
        }
    }
}

