/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.webservices.ClientConfig;
import org.wildfly.swarm.config.webservices.ClientConfigConsumer;
import org.wildfly.swarm.config.webservices.ClientConfigSupplier;
import org.wildfly.swarm.config.webservices.EndpointConfig;
import org.wildfly.swarm.config.webservices.EndpointConfigConsumer;
import org.wildfly.swarm.config.webservices.EndpointConfigSupplier;

@Address(value="/subsystem=webservices")
@ResourceType(value="subsystem")
@Implicit
public class Webservices<T extends Webservices<T>>
extends HashMap
implements Keyed {
    private String key = "webservices";
    private PropertyChangeSupport pcs;
    private WebservicesResources subresources = new WebservicesResources();
    @AttributeDocumentation(value="Whether the soap address can be modified.")
    private Boolean modifyWsdlAddress;
    @AttributeDocumentation(value="Whether statistics are to be gathered for endpoints, default value is 'false'.")
    private Boolean statisticsEnabled;
    @AttributeDocumentation(value="The WSDL, that is a required deployment artifact for an endpoint, has a <soap:address> element which points to the location of the endpoint. JBoss supports rewriting of that SOAP address. If the content of <soap:address> is a valid URL, JBossWS will not rewrite it unless 'modify-wsdl-address' is true. If the content of <soap:address> is not a valid URL, JBossWS will rewrite it using the attribute values given below. If 'wsdl-host' is set to 'jbossws.undefined.host', JBossWS uses requesters host when rewriting the <soap:address>")
    private String wsdlHost;
    @AttributeDocumentation(value="This string defines a SED substitution command (e.g., 's/regexp/replacement/g') that JBossWS executes against the path component of each <soap:address> URL published from the server. When wsdl-path-rewrite-rule is not defined, JBossWS retains the original path component of each <soap:address> URL. When 'modify-wsdl-address' is set to \"false\" this element is ignored.")
    private String wsdlPathRewriteRule;
    @AttributeDocumentation(value="The non-secure port that will be used for rewriting the SOAP address. If absent the port will be identified by querying the list of installed connectors.")
    private Integer wsdlPort;
    @AttributeDocumentation(value="The secure port that will be used for rewriting the SOAP address. If absent the port will be identified by querying the list of installed connectors.")
    private Integer wsdlSecurePort;
    @AttributeDocumentation(value="The URI scheme to use for rewriting <soap:address> . Valid values are 'http' and 'https'. This configuration overrides scheme computed by processing the endpoint (even if a transport guarantee is specified). The provided values for 'wsdl-port' and 'wsdl-secure-port' (or their default values) are used depending on specified scheme.")
    private WsdlUriScheme wsdlUriScheme;

    public Webservices() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public WebservicesResources subresources() {
        return this.subresources;
    }

    public T clientConfigs(List<ClientConfig> value) {
        this.subresources.clientConfigs = value;
        return (T)this;
    }

    public T clientConfig(ClientConfig value) {
        this.subresources.clientConfigs.add(value);
        return (T)this;
    }

    public T clientConfig(String childKey, ClientConfigConsumer consumer) {
        ClientConfig child = new ClientConfig(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.clientConfig(child);
        return (T)this;
    }

    public T clientConfig(String childKey) {
        this.clientConfig(childKey, null);
        return (T)this;
    }

    public T clientConfig(ClientConfigSupplier supplier) {
        this.clientConfig(supplier.get());
        return (T)this;
    }

    public T endpointConfigs(List<EndpointConfig> value) {
        this.subresources.endpointConfigs = value;
        return (T)this;
    }

    public T endpointConfig(EndpointConfig value) {
        this.subresources.endpointConfigs.add(value);
        return (T)this;
    }

    public T endpointConfig(String childKey, EndpointConfigConsumer consumer) {
        EndpointConfig child = new EndpointConfig(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.endpointConfig(child);
        return (T)this;
    }

    public T endpointConfig(String childKey) {
        this.endpointConfig(childKey, null);
        return (T)this;
    }

    public T endpointConfig(EndpointConfigSupplier supplier) {
        this.endpointConfig(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="modify-wsdl-address")
    public Boolean modifyWsdlAddress() {
        return this.modifyWsdlAddress;
    }

    public T modifyWsdlAddress(Boolean value) {
        Boolean oldValue = this.modifyWsdlAddress;
        this.modifyWsdlAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("modifyWsdlAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-host")
    public String wsdlHost() {
        return this.wsdlHost;
    }

    public T wsdlHost(String value) {
        String oldValue = this.wsdlHost;
        this.wsdlHost = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlHost", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-path-rewrite-rule")
    public String wsdlPathRewriteRule() {
        return this.wsdlPathRewriteRule;
    }

    public T wsdlPathRewriteRule(String value) {
        String oldValue = this.wsdlPathRewriteRule;
        this.wsdlPathRewriteRule = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlPathRewriteRule", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-port")
    public Integer wsdlPort() {
        return this.wsdlPort;
    }

    public T wsdlPort(Integer value) {
        Integer oldValue = this.wsdlPort;
        this.wsdlPort = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlPort", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-secure-port")
    public Integer wsdlSecurePort() {
        return this.wsdlSecurePort;
    }

    public T wsdlSecurePort(Integer value) {
        Integer oldValue = this.wsdlSecurePort;
        this.wsdlSecurePort = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlSecurePort", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-uri-scheme")
    public WsdlUriScheme wsdlUriScheme() {
        return this.wsdlUriScheme;
    }

    public T wsdlUriScheme(WsdlUriScheme value) {
        WsdlUriScheme oldValue = this.wsdlUriScheme;
        this.wsdlUriScheme = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlUriScheme", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum WsdlUriScheme {
        HTTP("http"),
        HTTPS("https");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private WsdlUriScheme(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class WebservicesResources {
        @ResourceDocumentation(value="Webservice client configuration")
        @SubresourceInfo(value="clientConfig")
        private List<ClientConfig> clientConfigs = new ArrayList<ClientConfig>();
        @ResourceDocumentation(value="Webservice endpoint configuration")
        @SubresourceInfo(value="endpointConfig")
        private List<EndpointConfig> endpointConfigs = new ArrayList<EndpointConfig>();

        @Subresource
        public List<ClientConfig> clientConfigs() {
            return this.clientConfigs;
        }

        public ClientConfig clientConfig(String key) {
            return this.clientConfigs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<EndpointConfig> endpointConfigs() {
            return this.endpointConfigs;
        }

        public EndpointConfig endpointConfig(String key) {
            return this.endpointConfigs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

