/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.datasources;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.datasources.FlushStrategy;
import org.wildfly.swarm.config.datasources.xa_data_source.XADatasourceProperties;
import org.wildfly.swarm.config.datasources.xa_data_source.XADatasourcePropertiesConsumer;
import org.wildfly.swarm.config.datasources.xa_data_source.XADatasourcePropertiesSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=datasources/xa-data-source=*")
@ResourceType(value="xa-data-source")
public class XADataSource<T extends XADataSource<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private XADataSourceResources subresources = new XADataSourceResources();
    @AttributeDocumentation(value="The allocation retry element indicates the number of times that allocating a connection should be tried before throwing an exception")
    private Integer allocationRetry;
    @AttributeDocumentation(value="The allocation retry wait millis element specifies the amount of time, in milliseconds, to wait between retrying to allocate a connection")
    private Long allocationRetryWaitMillis;
    @AttributeDocumentation(value="Specifies if multiple users will access the datasource through the getConnection(user, password) method and hence if the internal pool type should account for that")
    private Boolean allowMultipleUsers;
    @AttributeDocumentation(value="An element to specify that connections should be validated on a background thread versus being validated prior to use. Changing this value can be done only on disabled datasource,  requires a server restart otherwise.")
    private Boolean backgroundValidation;
    @AttributeDocumentation(value="The background-validation-millis element specifies the amount of time, in milliseconds, that background validation will run. Changing this value can be done only on disabled datasource,  requires a server restart otherwise")
    private Long backgroundValidationMillis;
    @AttributeDocumentation(value="The blocking-timeout-millis element specifies the maximum time, in milliseconds, to block while waiting for a connection before throwing an exception. Note that this blocks only while waiting for locking a connection, and will never throw an exception if creating a new connection takes an inordinately long time")
    private Long blockingTimeoutWaitMillis;
    @AttributeDocumentation(value="Class defining the policy for decrementing connections in the pool")
    private String capacityDecrementerClass;
    @AttributeDocumentation(value="Properties to inject in class defining the policy for decrementing connections in the pool")
    private Map capacityDecrementerProperties;
    @AttributeDocumentation(value="Class defining the policy for incrementing connections in the pool")
    private String capacityIncrementerClass;
    @AttributeDocumentation(value="Properties to inject in class defining the policy for incrementing connections in the pool")
    private Map capacityIncrementerProperties;
    @AttributeDocumentation(value="Specify an SQL statement to check validity of a pool connection. This may be called when managed connection is obtained from the pool")
    private String checkValidConnectionSql;
    @AttributeDocumentation(value="Enable the use of CMR for this datasource. This feature means that a local resource can reliably participate in an XA transaction.")
    private Boolean connectable;
    @AttributeDocumentation(value="Speciefies class name extending org.jboss.jca.adapters.jdbc.spi.listener.ConnectionListener that provides a possible to listen for connection activation and passivation in order to perform actions before the connection is returned to the application or returned to the pool.")
    private String connectionListenerClass;
    @AttributeDocumentation(value="Properties to be injected in class specified in connection-listener-class")
    private Map connectionListenerProperty;
    @AttributeDocumentation(value="Defines the JDBC driver the datasource should use. It is a symbolic name matching the the name of installed driver. In case the driver is deployed as jar, the name is the name of deployment unit")
    private String driverName;
    @AttributeDocumentation(value="Defines if WildFly/IronJacamar should record enlistment traces")
    private Boolean enlistmentTrace;
    @AttributeDocumentation(value="An org.jboss.jca.adapters.jdbc.ExceptionSorter that provides an isExceptionFatal(SQLException) method to validate if an exception should broadcast an error")
    private String exceptionSorterClassName;
    @AttributeDocumentation(value="The exception sorter properties")
    private Map exceptionSorterProperties;
    @AttributeDocumentation(value="Specifies how the pool should be flush in case of an error. Valid values are: FailingConnectionOnly (default), IdleConnections and EntirePool")
    private FlushStrategy flushStrategy;
    @AttributeDocumentation(value="The idle-timeout-minutes elements specifies the maximum time, in minutes, a connection may be idle before being closed. The actual maximum time depends also on the IdleRemover scan time, which is half of the smallest idle-timeout-minutes value of any pool. Changing this value can be done only on disabled datasource, requires a server restart otherwise.")
    private Long idleTimeoutMinutes;
    @AttributeDocumentation(value="The initial-pool-size element indicates the initial number of connections a pool should hold.")
    private Integer initialPoolSize;
    @AttributeDocumentation(value="An element to enable interleaving for XA connections")
    private Boolean interleaving;
    @AttributeDocumentation(value="Specifies the JNDI name for the datasource")
    private String jndiName;
    @AttributeDocumentation(value="The max-pool-size element specifies the maximum number of connections for a pool. No more connections will be created in each sub-pool")
    private Integer maxPoolSize;
    @AttributeDocumentation(value="Defines the ManagedConnectionPool implementation, f.ex. org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool")
    private String mcp;
    @AttributeDocumentation(value="The min-pool-size element specifies the minimum number of connections for a pool")
    private Integer minPoolSize;
    @AttributeDocumentation(value="Specifies an SQL statement to execute whenever a connection is added to the connection pool")
    private String newConnectionSql;
    @AttributeDocumentation(value="Specifies if the connection pool should be excluded from recovery")
    private Boolean noRecovery;
    @AttributeDocumentation(value="Oracle does not like XA connections getting used both inside and outside a JTA transaction. To workaround the problem you can create separate sub-pools for the different contexts")
    private Boolean noTxSeparatePool;
    @AttributeDocumentation(value="Should the Xid be padded")
    private Boolean padXid;
    @AttributeDocumentation(value="Specifies the password used when creating a new connection")
    private String password;
    @AttributeDocumentation(value="Defines if pool should use be fair")
    private Boolean poolFair;
    @AttributeDocumentation(value="Should the pool be prefilled. Changing this value can be done only on disabled datasource, requires a server restart otherwise.")
    private Boolean poolPrefill;
    @AttributeDocumentation(value="Specifies if the min-pool-size should be considered strictly")
    private Boolean poolUseStrictMin;
    @AttributeDocumentation(value="The number of prepared statements per connection in an LRU cache")
    private Long preparedStatementsCacheSize;
    @AttributeDocumentation(value="Any configured query timeout in seconds. If not provided no timeout will be set")
    private Long queryTimeout;
    @AttributeDocumentation(value="The fully qualified class name of the reauthentication plugin implementation")
    private String reauthPluginClassName;
    @AttributeDocumentation(value="The properties for the reauthentication plugin")
    private Map reauthPluginProperties;
    @AttributeDocumentation(value="The password used for recovery")
    private String recoveryPassword;
    @AttributeDocumentation(value="The fully qualified class name of the recovery plugin implementation")
    private String recoveryPluginClassName;
    @AttributeDocumentation(value="The properties for the recovery plugin")
    private Map recoveryPluginProperties;
    @AttributeDocumentation(value="The security domain used for recovery")
    private String recoverySecurityDomain;
    @AttributeDocumentation(value="The user name used for recovery")
    private String recoveryUsername;
    @AttributeDocumentation(value="The is-same-rm-override element allows one to unconditionally set whether the javax.transaction.xa.XAResource.isSameRM(XAResource) returns true or false")
    private Boolean sameRmOverride;
    @AttributeDocumentation(value="Specifies the security domain which defines the javax.security.auth.Subject that are used to distinguish connections in the pool")
    private String securityDomain;
    @AttributeDocumentation(value="Whether to set the query timeout based on the time remaining until transaction timeout. Any configured query timeout will be used if there is no transaction")
    private Boolean setTxQueryTimeout;
    @AttributeDocumentation(value="Whether to share prepared statements, i.e. whether asking for same statement twice without closing uses the same underlying prepared statement")
    private Boolean sharePreparedStatements;
    @AttributeDocumentation(value="Enable spying of SQL statements")
    private Boolean spy;
    @AttributeDocumentation(value="An org.jboss.jca.adapters.jdbc.StaleConnectionChecker that provides an isStaleConnection(SQLException) method which if it returns true will wrap the exception in an org.jboss.jca.adapters.jdbc.StaleConnectionException")
    private String staleConnectionCheckerClassName;
    @AttributeDocumentation(value="The stale connection checker properties")
    private Map staleConnectionCheckerProperties;
    @AttributeDocumentation(value="Define whether runtime statistics are enabled or not.")
    private Boolean statisticsEnabled;
    @AttributeDocumentation(value="Whether to check for unclosed statements when a connection is returned to the pool, result sets are closed, a statement is closed or return to the prepared statement cache. Valid values are: \"false\" - do not track statements, \"true\" - track statements and result sets and warn when they are not closed, \"nowarn\" - track statements but do not warn about them being unclosed")
    private String trackStatements;
    @AttributeDocumentation(value="Defines if IronJacamar should track connection handles across transaction boundaries")
    private Boolean tracking;
    @AttributeDocumentation(value="Set the java.sql.Connection transaction isolation level. Valid values are: TRANSACTION_READ_UNCOMMITTED, TRANSACTION_READ_COMMITTED, TRANSACTION_REPEATABLE_READ, TRANSACTION_SERIALIZABLE and TRANSACTION_NONE")
    private String transactionIsolation;
    @AttributeDocumentation(value="Specifies the delimiter for URLs in connection-url for HA datasources")
    private String urlDelimiter;
    @AttributeDocumentation(value="Specifies the property for the URL property in the xa-datasource-property values")
    private String urlProperty;
    @AttributeDocumentation(value="A class that implements org.jboss.jca.adapters.jdbc.URLSelectorStrategy")
    private String urlSelectorStrategyClassName;
    @AttributeDocumentation(value="Enable the use of a cached connection manager")
    private Boolean useCcm;
    @AttributeDocumentation(value="Whether to fail a connection allocation on the first try if it is invalid (true) or keep trying until the pool is exhausted of all potential connections (false)")
    private Boolean useFastFail;
    @AttributeDocumentation(value="Setting this to false will bind the datasource into global JNDI")
    private Boolean useJavaContext;
    @AttributeDocumentation(value="Any configured timeout for internal locks on the resource adapter objects in seconds")
    private Long useTryLock;
    @AttributeDocumentation(value="Specify the user name used when creating a new connection")
    private String userName;
    @AttributeDocumentation(value="An org.jboss.jca.adapters.jdbc.ValidConnectionChecker that provides an isValidConnection(Connection) method to validate a connection. If an exception is returned that means the connection is invalid. This overrides the check-valid-connection-sql element")
    private String validConnectionCheckerClassName;
    @AttributeDocumentation(value="The valid connection checker properties")
    private Map validConnectionCheckerProperties;
    @AttributeDocumentation(value="The validate-on-match element specifies if connection validation should be done when a connection factory attempts to match a managed connection. This is typically exclusive to the use of background validation")
    private Boolean validateOnMatch;
    @AttributeDocumentation(value="Should the XAResource instances be wrapped in an org.jboss.tm.XAResourceWrapper instance")
    private Boolean wrapXaResource;
    @AttributeDocumentation(value="The fully qualified name of the javax.sql.XADataSource implementation")
    private String xaDatasourceClass;
    @AttributeDocumentation(value="The value is passed to XAResource.setTransactionTimeout(), in seconds. Default is zero")
    private Integer xaResourceTimeout;

    public XADataSource(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public XADataSourceResources subresources() {
        return this.subresources;
    }

    public T xaDatasourceProperties(List<XADatasourceProperties> value) {
        this.subresources.xaDatasourceProperties = value;
        return (T)this;
    }

    public T xaDatasourceProperties(XADatasourceProperties value) {
        this.subresources.xaDatasourceProperties.add(value);
        return (T)this;
    }

    public T xaDatasourceProperties(String childKey, XADatasourcePropertiesConsumer consumer) {
        XADatasourceProperties child = new XADatasourceProperties(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.xaDatasourceProperties(child);
        return (T)this;
    }

    public T xaDatasourceProperties(String childKey) {
        this.xaDatasourceProperties(childKey, null);
        return (T)this;
    }

    public T xaDatasourceProperties(XADatasourcePropertiesSupplier supplier) {
        this.xaDatasourceProperties(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allocation-retry")
    public Integer allocationRetry() {
        return this.allocationRetry;
    }

    public T allocationRetry(Integer value) {
        Integer oldValue = this.allocationRetry;
        this.allocationRetry = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetry", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allocation-retry-wait-millis")
    public Long allocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public T allocationRetryWaitMillis(Long value) {
        Long oldValue = this.allocationRetryWaitMillis;
        this.allocationRetryWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetryWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-multiple-users")
    public Boolean allowMultipleUsers() {
        return this.allowMultipleUsers;
    }

    public T allowMultipleUsers(Boolean value) {
        Boolean oldValue = this.allowMultipleUsers;
        this.allowMultipleUsers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowMultipleUsers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation")
    public Boolean backgroundValidation() {
        return this.backgroundValidation;
    }

    public T backgroundValidation(Boolean value) {
        Boolean oldValue = this.backgroundValidation;
        this.backgroundValidation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation-millis")
    public Long backgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    public T backgroundValidationMillis(Long value) {
        Long oldValue = this.backgroundValidationMillis;
        this.backgroundValidationMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidationMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="blocking-timeout-wait-millis")
    public Long blockingTimeoutWaitMillis() {
        return this.blockingTimeoutWaitMillis;
    }

    public T blockingTimeoutWaitMillis(Long value) {
        Long oldValue = this.blockingTimeoutWaitMillis;
        this.blockingTimeoutWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockingTimeoutWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-class")
    public String capacityDecrementerClass() {
        return this.capacityDecrementerClass;
    }

    public T capacityDecrementerClass(String value) {
        String oldValue = this.capacityDecrementerClass;
        this.capacityDecrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-properties")
    public Map capacityDecrementerProperties() {
        return this.capacityDecrementerProperties;
    }

    public T capacityDecrementerProperties(Map value) {
        Map oldValue = this.capacityDecrementerProperties;
        this.capacityDecrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityDecrementerProperty(String key, Object value) {
        if (this.capacityDecrementerProperties == null) {
            this.capacityDecrementerProperties = new HashMap();
        }
        this.capacityDecrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-class")
    public String capacityIncrementerClass() {
        return this.capacityIncrementerClass;
    }

    public T capacityIncrementerClass(String value) {
        String oldValue = this.capacityIncrementerClass;
        this.capacityIncrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-properties")
    public Map capacityIncrementerProperties() {
        return this.capacityIncrementerProperties;
    }

    public T capacityIncrementerProperties(Map value) {
        Map oldValue = this.capacityIncrementerProperties;
        this.capacityIncrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityIncrementerProperty(String key, Object value) {
        if (this.capacityIncrementerProperties == null) {
            this.capacityIncrementerProperties = new HashMap();
        }
        this.capacityIncrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="check-valid-connection-sql")
    public String checkValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    public T checkValidConnectionSql(String value) {
        String oldValue = this.checkValidConnectionSql;
        this.checkValidConnectionSql = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("checkValidConnectionSql", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connectable")
    public Boolean connectable() {
        return this.connectable;
    }

    public T connectable(Boolean value) {
        Boolean oldValue = this.connectable;
        this.connectable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-listener-class")
    public String connectionListenerClass() {
        return this.connectionListenerClass;
    }

    public T connectionListenerClass(String value) {
        String oldValue = this.connectionListenerClass;
        this.connectionListenerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionListenerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-listener-property")
    public Map connectionListenerProperty() {
        return this.connectionListenerProperty;
    }

    public T connectionListenerProperty(Map value) {
        Map oldValue = this.connectionListenerProperty;
        this.connectionListenerProperty = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionListenerProperty", oldValue, value);
        }
        return (T)this;
    }

    public T connectionListenerProperty(String key, Object value) {
        if (this.connectionListenerProperty == null) {
            this.connectionListenerProperty = new HashMap();
        }
        this.connectionListenerProperty.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-name")
    public String driverName() {
        return this.driverName;
    }

    public T driverName(String value) {
        String oldValue = this.driverName;
        this.driverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enlistment-trace")
    public Boolean enlistmentTrace() {
        return this.enlistmentTrace;
    }

    public T enlistmentTrace(Boolean value) {
        Boolean oldValue = this.enlistmentTrace;
        this.enlistmentTrace = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enlistmentTrace", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-sorter-class-name")
    public String exceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    public T exceptionSorterClassName(String value) {
        String oldValue = this.exceptionSorterClassName;
        this.exceptionSorterClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionSorterClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-sorter-properties")
    public Map exceptionSorterProperties() {
        return this.exceptionSorterProperties;
    }

    public T exceptionSorterProperties(Map value) {
        Map oldValue = this.exceptionSorterProperties;
        this.exceptionSorterProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionSorterProperties", oldValue, value);
        }
        return (T)this;
    }

    public T exceptionSorterProperty(String key, Object value) {
        if (this.exceptionSorterProperties == null) {
            this.exceptionSorterProperties = new HashMap();
        }
        this.exceptionSorterProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="flush-strategy")
    public FlushStrategy flushStrategy() {
        return this.flushStrategy;
    }

    public T flushStrategy(FlushStrategy value) {
        FlushStrategy oldValue = this.flushStrategy;
        this.flushStrategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("flushStrategy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="idle-timeout-minutes")
    public Long idleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public T idleTimeoutMinutes(Long value) {
        Long oldValue = this.idleTimeoutMinutes;
        this.idleTimeoutMinutes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idleTimeoutMinutes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-pool-size")
    public Integer initialPoolSize() {
        return this.initialPoolSize;
    }

    public T initialPoolSize(Integer value) {
        Integer oldValue = this.initialPoolSize;
        this.initialPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="interleaving")
    public Boolean interleaving() {
        return this.interleaving;
    }

    public T interleaving(Boolean value) {
        Boolean oldValue = this.interleaving;
        this.interleaving = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("interleaving", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mcp")
    public String mcp() {
        return this.mcp;
    }

    public T mcp(String value) {
        String oldValue = this.mcp;
        this.mcp = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mcp", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-pool-size")
    public Integer minPoolSize() {
        return this.minPoolSize;
    }

    public T minPoolSize(Integer value) {
        Integer oldValue = this.minPoolSize;
        this.minPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="new-connection-sql")
    public String newConnectionSql() {
        return this.newConnectionSql;
    }

    public T newConnectionSql(String value) {
        String oldValue = this.newConnectionSql;
        this.newConnectionSql = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("newConnectionSql", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-recovery")
    public Boolean noRecovery() {
        return this.noRecovery;
    }

    public T noRecovery(Boolean value) {
        Boolean oldValue = this.noRecovery;
        this.noRecovery = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noRecovery", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-tx-separate-pool")
    public Boolean noTxSeparatePool() {
        return this.noTxSeparatePool;
    }

    public T noTxSeparatePool(Boolean value) {
        Boolean oldValue = this.noTxSeparatePool;
        this.noTxSeparatePool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noTxSeparatePool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pad-xid")
    public Boolean padXid() {
        return this.padXid;
    }

    public T padXid(Boolean value) {
        Boolean oldValue = this.padXid;
        this.padXid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("padXid", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="password")
    public String password() {
        return this.password;
    }

    public T password(String value) {
        String oldValue = this.password;
        this.password = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("password", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-fair")
    public Boolean poolFair() {
        return this.poolFair;
    }

    public T poolFair(Boolean value) {
        Boolean oldValue = this.poolFair;
        this.poolFair = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolFair", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-prefill")
    public Boolean poolPrefill() {
        return this.poolPrefill;
    }

    public T poolPrefill(Boolean value) {
        Boolean oldValue = this.poolPrefill;
        this.poolPrefill = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolPrefill", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-use-strict-min")
    public Boolean poolUseStrictMin() {
        return this.poolUseStrictMin;
    }

    public T poolUseStrictMin(Boolean value) {
        Boolean oldValue = this.poolUseStrictMin;
        this.poolUseStrictMin = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolUseStrictMin", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="prepared-statements-cache-size")
    public Long preparedStatementsCacheSize() {
        return this.preparedStatementsCacheSize;
    }

    public T preparedStatementsCacheSize(Long value) {
        Long oldValue = this.preparedStatementsCacheSize;
        this.preparedStatementsCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preparedStatementsCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="query-timeout")
    public Long queryTimeout() {
        return this.queryTimeout;
    }

    public T queryTimeout(Long value) {
        Long oldValue = this.queryTimeout;
        this.queryTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queryTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reauth-plugin-class-name")
    public String reauthPluginClassName() {
        return this.reauthPluginClassName;
    }

    public T reauthPluginClassName(String value) {
        String oldValue = this.reauthPluginClassName;
        this.reauthPluginClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reauthPluginClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reauth-plugin-properties")
    public Map reauthPluginProperties() {
        return this.reauthPluginProperties;
    }

    public T reauthPluginProperties(Map value) {
        Map oldValue = this.reauthPluginProperties;
        this.reauthPluginProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reauthPluginProperties", oldValue, value);
        }
        return (T)this;
    }

    public T reauthPluginProperty(String key, Object value) {
        if (this.reauthPluginProperties == null) {
            this.reauthPluginProperties = new HashMap();
        }
        this.reauthPluginProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-password")
    public String recoveryPassword() {
        return this.recoveryPassword;
    }

    public T recoveryPassword(String value) {
        String oldValue = this.recoveryPassword;
        this.recoveryPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-plugin-class-name")
    public String recoveryPluginClassName() {
        return this.recoveryPluginClassName;
    }

    public T recoveryPluginClassName(String value) {
        String oldValue = this.recoveryPluginClassName;
        this.recoveryPluginClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPluginClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-plugin-properties")
    public Map recoveryPluginProperties() {
        return this.recoveryPluginProperties;
    }

    public T recoveryPluginProperties(Map value) {
        Map oldValue = this.recoveryPluginProperties;
        this.recoveryPluginProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPluginProperties", oldValue, value);
        }
        return (T)this;
    }

    public T recoveryPluginProperty(String key, Object value) {
        if (this.recoveryPluginProperties == null) {
            this.recoveryPluginProperties = new HashMap();
        }
        this.recoveryPluginProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-security-domain")
    public String recoverySecurityDomain() {
        return this.recoverySecurityDomain;
    }

    public T recoverySecurityDomain(String value) {
        String oldValue = this.recoverySecurityDomain;
        this.recoverySecurityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoverySecurityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-username")
    public String recoveryUsername() {
        return this.recoveryUsername;
    }

    public T recoveryUsername(String value) {
        String oldValue = this.recoveryUsername;
        this.recoveryUsername = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryUsername", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="same-rm-override")
    public Boolean sameRmOverride() {
        return this.sameRmOverride;
    }

    public T sameRmOverride(Boolean value) {
        Boolean oldValue = this.sameRmOverride;
        this.sameRmOverride = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sameRmOverride", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="set-tx-query-timeout")
    public Boolean setTxQueryTimeout() {
        return this.setTxQueryTimeout;
    }

    public T setTxQueryTimeout(Boolean value) {
        Boolean oldValue = this.setTxQueryTimeout;
        this.setTxQueryTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("setTxQueryTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="share-prepared-statements")
    public Boolean sharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public T sharePreparedStatements(Boolean value) {
        Boolean oldValue = this.sharePreparedStatements;
        this.sharePreparedStatements = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sharePreparedStatements", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="spy")
    public Boolean spy() {
        return this.spy;
    }

    public T spy(Boolean value) {
        Boolean oldValue = this.spy;
        this.spy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("spy", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stale-connection-checker-class-name")
    public String staleConnectionCheckerClassName() {
        return this.staleConnectionCheckerClassName;
    }

    public T staleConnectionCheckerClassName(String value) {
        String oldValue = this.staleConnectionCheckerClassName;
        this.staleConnectionCheckerClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staleConnectionCheckerClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stale-connection-checker-properties")
    public Map staleConnectionCheckerProperties() {
        return this.staleConnectionCheckerProperties;
    }

    public T staleConnectionCheckerProperties(Map value) {
        Map oldValue = this.staleConnectionCheckerProperties;
        this.staleConnectionCheckerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staleConnectionCheckerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T staleConnectionCheckerProperty(String key, Object value) {
        if (this.staleConnectionCheckerProperties == null) {
            this.staleConnectionCheckerProperties = new HashMap();
        }
        this.staleConnectionCheckerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="track-statements")
    public String trackStatements() {
        return this.trackStatements;
    }

    public T trackStatements(String value) {
        String oldValue = this.trackStatements;
        this.trackStatements = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trackStatements", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tracking")
    public Boolean tracking() {
        return this.tracking;
    }

    public T tracking(Boolean value) {
        Boolean oldValue = this.tracking;
        this.tracking = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tracking", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction-isolation")
    public String transactionIsolation() {
        return this.transactionIsolation;
    }

    public T transactionIsolation(String value) {
        String oldValue = this.transactionIsolation;
        this.transactionIsolation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactionIsolation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-delimiter")
    public String urlDelimiter() {
        return this.urlDelimiter;
    }

    public T urlDelimiter(String value) {
        String oldValue = this.urlDelimiter;
        this.urlDelimiter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlDelimiter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-property")
    public String urlProperty() {
        return this.urlProperty;
    }

    public T urlProperty(String value) {
        String oldValue = this.urlProperty;
        this.urlProperty = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlProperty", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-selector-strategy-class-name")
    public String urlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public T urlSelectorStrategyClassName(String value) {
        String oldValue = this.urlSelectorStrategyClassName;
        this.urlSelectorStrategyClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlSelectorStrategyClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-ccm")
    public Boolean useCcm() {
        return this.useCcm;
    }

    public T useCcm(Boolean value) {
        Boolean oldValue = this.useCcm;
        this.useCcm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useCcm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-fast-fail")
    public Boolean useFastFail() {
        return this.useFastFail;
    }

    public T useFastFail(Boolean value) {
        Boolean oldValue = this.useFastFail;
        this.useFastFail = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useFastFail", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-java-context")
    public Boolean useJavaContext() {
        return this.useJavaContext;
    }

    public T useJavaContext(Boolean value) {
        Boolean oldValue = this.useJavaContext;
        this.useJavaContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJavaContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-try-lock")
    public Long useTryLock() {
        return this.useTryLock;
    }

    public T useTryLock(Long value) {
        Long oldValue = this.useTryLock;
        this.useTryLock = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useTryLock", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="user-name")
    public String userName() {
        return this.userName;
    }

    public T userName(String value) {
        String oldValue = this.userName;
        this.userName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("userName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="valid-connection-checker-class-name")
    public String validConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    public T validConnectionCheckerClassName(String value) {
        String oldValue = this.validConnectionCheckerClassName;
        this.validConnectionCheckerClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validConnectionCheckerClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="valid-connection-checker-properties")
    public Map validConnectionCheckerProperties() {
        return this.validConnectionCheckerProperties;
    }

    public T validConnectionCheckerProperties(Map value) {
        Map oldValue = this.validConnectionCheckerProperties;
        this.validConnectionCheckerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validConnectionCheckerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T validConnectionCheckerProperty(String key, Object value) {
        if (this.validConnectionCheckerProperties == null) {
            this.validConnectionCheckerProperties = new HashMap();
        }
        this.validConnectionCheckerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="validate-on-match")
    public Boolean validateOnMatch() {
        return this.validateOnMatch;
    }

    public T validateOnMatch(Boolean value) {
        Boolean oldValue = this.validateOnMatch;
        this.validateOnMatch = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validateOnMatch", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wrap-xa-resource")
    public Boolean wrapXaResource() {
        return this.wrapXaResource;
    }

    public T wrapXaResource(Boolean value) {
        Boolean oldValue = this.wrapXaResource;
        this.wrapXaResource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wrapXaResource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="xa-datasource-class")
    public String xaDatasourceClass() {
        return this.xaDatasourceClass;
    }

    public T xaDatasourceClass(String value) {
        String oldValue = this.xaDatasourceClass;
        this.xaDatasourceClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("xaDatasourceClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="xa-resource-timeout")
    public Integer xaResourceTimeout() {
        return this.xaResourceTimeout;
    }

    public T xaResourceTimeout(Integer value) {
        Integer oldValue = this.xaResourceTimeout;
        this.xaResourceTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("xaResourceTimeout", oldValue, value);
        }
        return (T)this;
    }

    public static class XADataSourceResources {
        @ResourceDocumentation(value="List of xa-datasource-property")
        @SubresourceInfo(value="xaDatasourceProperties")
        private List<XADatasourceProperties> xaDatasourceProperties = new ArrayList<XADatasourceProperties>();

        @Subresource
        public List<XADatasourceProperties> xaDatasourceProperties() {
            return this.xaDatasourceProperties;
        }

        public XADatasourceProperties xaDatasourceProperties(String key) {
            return this.xaDatasourceProperties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

