/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ee;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.ee.RejectPolicy;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ee/managed-scheduled-executor-service=*")
@ResourceType(value="managed-scheduled-executor-service")
public class ManagedScheduledExecutorService<T extends ManagedScheduledExecutorService<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the context service to be used by the scheduled executor.")
    private String contextService;
    @AttributeDocumentation(value="The minimum number of threads to be used by the scheduled executor.")
    private Integer coreThreads;
    @AttributeDocumentation(value="The runtime, in milliseconds, for tasks to be considered hung by the scheduled executor. If 0 tasks are never considered hung.")
    private Long hungTaskThreshold;
    @AttributeDocumentation(value="The JNDI Name to lookup the managed scheduled executor service.")
    private String jndiName;
    @AttributeDocumentation(value="When the number of threads is greater than the core, this is the maximum time, in milliseconds, that excess idle threads will wait for new tasks before terminating.")
    private Long keepaliveTime;
    @AttributeDocumentation(value="Flag which hints the duration of tasks executed by the scheduled executor.")
    private Boolean longRunningTasks;
    @AttributeDocumentation(value="The policy to be applied to aborted tasks.")
    private RejectPolicy rejectPolicy;
    @AttributeDocumentation(value="The name of the thread factory to be used by the scheduled executor.")
    private String threadFactory;

    public ManagedScheduledExecutorService(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="context-service")
    public String contextService() {
        return this.contextService;
    }

    public T contextService(String value) {
        String oldValue = this.contextService;
        this.contextService = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("contextService", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="core-threads")
    public Integer coreThreads() {
        return this.coreThreads;
    }

    public T coreThreads(Integer value) {
        Integer oldValue = this.coreThreads;
        this.coreThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("coreThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="hung-task-threshold")
    public Long hungTaskThreshold() {
        return this.hungTaskThreshold;
    }

    public T hungTaskThreshold(Long value) {
        Long oldValue = this.hungTaskThreshold;
        this.hungTaskThreshold = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hungTaskThreshold", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keepalive-time")
    public Long keepaliveTime() {
        return this.keepaliveTime;
    }

    public T keepaliveTime(Long value) {
        Long oldValue = this.keepaliveTime;
        this.keepaliveTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keepaliveTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="long-running-tasks")
    public Boolean longRunningTasks() {
        return this.longRunningTasks;
    }

    public T longRunningTasks(Boolean value) {
        Boolean oldValue = this.longRunningTasks;
        this.longRunningTasks = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("longRunningTasks", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reject-policy")
    public RejectPolicy rejectPolicy() {
        return this.rejectPolicy;
    }

    public T rejectPolicy(RejectPolicy value) {
        RejectPolicy oldValue = this.rejectPolicy;
        this.rejectPolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("rejectPolicy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-factory")
    public String threadFactory() {
        return this.threadFactory;
    }

    public T threadFactory(String value) {
        String oldValue = this.threadFactory;
        this.threadFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadFactory", oldValue, value);
        }
        return (T)this;
    }
}

