/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=io/worker=*")
@ResourceType(value="worker")
public class Worker<T extends Worker<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Specify the number of I/O threads to create for the worker.  If not specified, a default will be chosen, which is calculated by cpuCount * 2")
    private Integer ioThreads;
    @AttributeDocumentation(value="The stack size (in bytes) to attempt to use for worker threads.")
    private Long stackSize;
    @AttributeDocumentation(value="Specify the number of milliseconds to keep non-core task threads alive.")
    private Integer taskKeepalive;
    @AttributeDocumentation(value="Specify the maximum number of threads for the worker task thread pool.If not set, default value used which is calculated by formula cpuCount * 16")
    private Integer taskMaxThreads;

    public Worker(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="io-threads")
    public Integer ioThreads() {
        return this.ioThreads;
    }

    public T ioThreads(Integer value) {
        Integer oldValue = this.ioThreads;
        this.ioThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ioThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stack-size")
    public Long stackSize() {
        return this.stackSize;
    }

    public T stackSize(Long value) {
        Long oldValue = this.stackSize;
        this.stackSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stackSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="task-keepalive")
    public Integer taskKeepalive() {
        return this.taskKeepalive;
    }

    public T taskKeepalive(Integer value) {
        Integer oldValue = this.taskKeepalive;
        this.taskKeepalive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("taskKeepalive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="task-max-threads")
    public Integer taskMaxThreads() {
        return this.taskMaxThreads;
    }

    public T taskMaxThreads(Integer value) {
        Integer oldValue = this.taskMaxThreads;
        this.taskMaxThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("taskMaxThreads", oldValue, value);
        }
        return (T)this;
    }
}

