/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jgroups;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.jgroups.channel.Fork;
import org.wildfly.swarm.config.jgroups.channel.ForkConsumer;
import org.wildfly.swarm.config.jgroups.channel.ForkSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=jgroups/channel=*")
@ResourceType(value="channel")
public class Channel<T extends Channel<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ChannelResources subresources = new ChannelResources();
    @AttributeDocumentation(value="The IP address of the channel.")
    private String address;
    @AttributeDocumentation(value="The address of the channel as a UUID.")
    private String addressAsUuid;
    @AttributeDocumentation(value="The cluster name of the JGroups channel. If undefined, the name of the channel will be used.")
    private String cluster;
    @AttributeDocumentation(value="If true, do not receive messages sent by this node (ourself).")
    private Boolean discardOwnMessages;
    @AttributeDocumentation(value="The module from which to load channel services")
    private String module;
    @AttributeDocumentation(value="The current number of timer tasks.")
    private Integer numTasksInTimer;
    @AttributeDocumentation(value="The number of timer threads.")
    private Integer numTimerThreads;
    @AttributeDocumentation(value="The number of bytes received by this channel.")
    private Long receivedBytes;
    @AttributeDocumentation(value="The number of messages received by this channel.")
    private Long receivedMessages;
    @AttributeDocumentation(value="The number of bytes sent by this channel.")
    private Long sentBytes;
    @AttributeDocumentation(value="The number of messages sent by this channel.")
    private Long sentMessages;
    @AttributeDocumentation(value="The protocol stack of the JGroups channel")
    private String stack;
    @AttributeDocumentation(value="The state of the channel (OPEN, CONNECTING, CONNECTED, CLOSED).")
    private String state;
    @AttributeDocumentation(value="If enabled, collect channel statistics.")
    private Boolean statsEnabled;
    @AttributeDocumentation(value="The JGroups software version.")
    private String version;
    @AttributeDocumentation(value="The channel's view of group membership.")
    private String view;

    public Channel(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ChannelResources subresources() {
        return this.subresources;
    }

    public T forks(List<Fork> value) {
        this.subresources.forks = value;
        return (T)this;
    }

    public T fork(Fork value) {
        this.subresources.forks.add(value);
        return (T)this;
    }

    public T fork(String childKey, ForkConsumer consumer) {
        Fork child = new Fork(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.fork(child);
        return (T)this;
    }

    public T fork(String childKey) {
        this.fork(childKey, null);
        return (T)this;
    }

    public T fork(ForkSupplier supplier) {
        this.fork(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="address")
    public String address() {
        return this.address;
    }

    public T address(String value) {
        String oldValue = this.address;
        this.address = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("address", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="address-as-uuid")
    public String addressAsUuid() {
        return this.addressAsUuid;
    }

    public T addressAsUuid(String value) {
        String oldValue = this.addressAsUuid;
        this.addressAsUuid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("addressAsUuid", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cluster")
    public String cluster() {
        return this.cluster;
    }

    public T cluster(String value) {
        String oldValue = this.cluster;
        this.cluster = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cluster", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="discard-own-messages")
    public Boolean discardOwnMessages() {
        return this.discardOwnMessages;
    }

    public T discardOwnMessages(Boolean value) {
        Boolean oldValue = this.discardOwnMessages;
        this.discardOwnMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("discardOwnMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="num-tasks-in-timer")
    public Integer numTasksInTimer() {
        return this.numTasksInTimer;
    }

    public T numTasksInTimer(Integer value) {
        Integer oldValue = this.numTasksInTimer;
        this.numTasksInTimer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numTasksInTimer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="num-timer-threads")
    public Integer numTimerThreads() {
        return this.numTimerThreads;
    }

    public T numTimerThreads(Integer value) {
        Integer oldValue = this.numTimerThreads;
        this.numTimerThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numTimerThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="received-bytes")
    public Long receivedBytes() {
        return this.receivedBytes;
    }

    public T receivedBytes(Long value) {
        Long oldValue = this.receivedBytes;
        this.receivedBytes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receivedBytes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="received-messages")
    public Long receivedMessages() {
        return this.receivedMessages;
    }

    public T receivedMessages(Long value) {
        Long oldValue = this.receivedMessages;
        this.receivedMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receivedMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sent-bytes")
    public Long sentBytes() {
        return this.sentBytes;
    }

    public T sentBytes(Long value) {
        Long oldValue = this.sentBytes;
        this.sentBytes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sentBytes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sent-messages")
    public Long sentMessages() {
        return this.sentMessages;
    }

    public T sentMessages(Long value) {
        Long oldValue = this.sentMessages;
        this.sentMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sentMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stack")
    public String stack() {
        return this.stack;
    }

    public T stack(String value) {
        String oldValue = this.stack;
        this.stack = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stack", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="state")
    public String state() {
        return this.state;
    }

    public T state(String value) {
        String oldValue = this.state;
        this.state = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("state", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stats-enabled")
    public Boolean statsEnabled() {
        return this.statsEnabled;
    }

    public T statsEnabled(Boolean value) {
        Boolean oldValue = this.statsEnabled;
        this.statsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="version")
    public String version() {
        return this.version;
    }

    public T version(String value) {
        String oldValue = this.version;
        this.version = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("version", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="view")
    public String view() {
        return this.view;
    }

    public T view(String value) {
        String oldValue = this.view;
        this.view = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("view", oldValue, value);
        }
        return (T)this;
    }

    public static class ChannelResources {
        @ResourceDocumentation(value="A JGroups channel fork")
        @SubresourceInfo(value="fork")
        private List<Fork> forks = new ArrayList<Fork>();

        @Subresource
        public List<Fork> forks() {
            return this.forks;
        }

        public Fork fork(String key) {
            return this.forks.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

