/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/management-interface=http-interface")
@ResourceType(value="management-interface")
@Implicit
public class HTTPInterfaceManagementInterface<T extends HTTPInterfaceManagementInterface<T>>
extends HashMap
implements Keyed {
    private String key = "http-interface";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Comma separated list of trusted Origins for sending Cross-Origin Resource Sharing requests on the management API once the user is authenticated.")
    private List<String> allowedOrigins;
    @AttributeDocumentation(value="Flag that indicates admin console is enabled")
    private Boolean consoleEnabled;
    @AttributeDocumentation(value="Flag that indicates HTTP Upgrade is enabled, which allows HTTP requests to be upgraded to native remoting connections")
    private Boolean httpUpgradeEnabled;
    @AttributeDocumentation(value="The name of the protocol to be passed to the SASL mechanisms used for authentication.")
    private String saslProtocol;
    @AttributeDocumentation(value="The name of the socket binding configuration to use for the HTTPS management interface's socket.")
    private String secureSocketBinding;
    @AttributeDocumentation(value="The security realm to use for the HTTP management interface.")
    private String securityRealm;
    @AttributeDocumentation(value="The name of the server used in the initial Remoting exchange and within the SASL mechanisms.")
    private String serverName;
    @AttributeDocumentation(value="The name of the socket binding configuration to use for the HTTP management interface's socket.")
    private String socketBinding;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allowed-origins")
    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public T allowedOrigins(List<String> value) {
        List<String> oldValue = this.allowedOrigins;
        this.allowedOrigins = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowedOrigins", oldValue, value);
        }
        return (T)this;
    }

    public T allowedOrigin(String value) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.add(value);
        return (T)this;
    }

    public T allowedOrigins(String ... args) {
        this.allowedOrigins(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="console-enabled")
    public Boolean consoleEnabled() {
        return this.consoleEnabled;
    }

    public T consoleEnabled(Boolean value) {
        Boolean oldValue = this.consoleEnabled;
        this.consoleEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("consoleEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http-upgrade-enabled")
    public Boolean httpUpgradeEnabled() {
        return this.httpUpgradeEnabled;
    }

    public T httpUpgradeEnabled(Boolean value) {
        Boolean oldValue = this.httpUpgradeEnabled;
        this.httpUpgradeEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("httpUpgradeEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-protocol")
    public String saslProtocol() {
        return this.saslProtocol;
    }

    public T saslProtocol(String value) {
        String oldValue = this.saslProtocol;
        this.saslProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="secure-socket-binding")
    public String secureSocketBinding() {
        return this.secureSocketBinding;
    }

    public T secureSocketBinding(String value) {
        String oldValue = this.secureSocketBinding;
        this.secureSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("secureSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        String oldValue = this.serverName;
        this.serverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }
}

