/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/http-acceptor=*")
@ResourceType(value="http-acceptor")
public class HTTPAcceptor<T extends HTTPAcceptor<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The Undertow's http-listener that handles HTTP upgrade requests.")
    private String httpListener;
    @AttributeDocumentation(value="A key-value pair understood by the acceptor factory-class and used to configure it.")
    private Map params;
    @AttributeDocumentation(value="Also accepts to upgrade HTTP request from legacy (HornetQ) clients.")
    private Boolean upgradeLegacy;

    public HTTPAcceptor(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="http-listener")
    public String httpListener() {
        return this.httpListener;
    }

    public T httpListener(String value) {
        String oldValue = this.httpListener;
        this.httpListener = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("httpListener", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="params")
    public Map params() {
        return this.params;
    }

    public T params(Map value) {
        Map oldValue = this.params;
        this.params = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("params", oldValue, value);
        }
        return (T)this;
    }

    public T param(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="upgrade-legacy")
    public Boolean upgradeLegacy() {
        return this.upgradeLegacy;
    }

    public T upgradeLegacy(Boolean value) {
        Boolean oldValue = this.upgradeLegacy;
        this.upgradeLegacy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("upgradeLegacy", oldValue, value);
        }
        return (T)this;
    }
}

