/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.resource.adapters;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.AdminObjects;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.AdminObjectsConsumer;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.AdminObjectsSupplier;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigProperties;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigPropertiesConsumer;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigPropertiesSupplier;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConnectionDefinitions;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConnectionDefinitionsConsumer;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConnectionDefinitionsSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=resource-adapters/resource-adapter=*")
@ResourceType(value="resource-adapter")
public class ResourceAdapter<T extends ResourceAdapter<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ResourceAdapterResources subresources = new ResourceAdapterResources();
    @AttributeDocumentation(value="Specifies the resource adapter archive.")
    private String archive;
    @AttributeDocumentation(value="Specifies the bean validation groups that should be used.")
    private List<String> beanvalidationgroups;
    @AttributeDocumentation(value="Specifies the unique name of the bootstrap context that should be used.")
    private String bootstrapContext;
    @AttributeDocumentation(value="Specifies the module from which resource adapter will be loaded")
    private String module;
    @AttributeDocumentation(value="Define whether runtime statistics are enabled or not.")
    private Boolean statisticsEnabled;
    @AttributeDocumentation(value="Specifies the transaction support level of the resource adapter.")
    private TransactionSupport transactionSupport;
    @AttributeDocumentation(value="Toggle on/off wm.security for this resource-adapter. In case of false all wm-security-* parameters are ignored, even thei defaults.")
    private Boolean wmSecurity;
    @AttributeDocumentation(value="Defines a default groups list that should be added to the used Subject instance")
    private List<String> wmSecurityDefaultGroups;
    @AttributeDocumentation(value="Defines a default principal name that should be added to the used Subject instance")
    private String wmSecurityDefaultPrincipal;
    @AttributeDocumentation(value="Defines the name of the security domain that should be used")
    private String wmSecurityDomain;
    @AttributeDocumentation(value="List of groups mappings")
    private List<Map> wmSecurityMappingGroups;
    @AttributeDocumentation(value="Defines if a mapping is required for security credentials. A value of false means Case 1 as defined in section 16.4.3, and a value of true means Case 2 as defined in section 16.4.4.")
    private Boolean wmSecurityMappingRequired;
    @AttributeDocumentation(value="List of user mappings")
    private List<Map> wmSecurityMappingUsers;

    public ResourceAdapter(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ResourceAdapterResources subresources() {
        return this.subresources;
    }

    public T configProperties(List<ConfigProperties> value) {
        this.subresources.configProperties = value;
        return (T)this;
    }

    public T configProperties(ConfigProperties value) {
        this.subresources.configProperties.add(value);
        return (T)this;
    }

    public T configProperties(String childKey, ConfigPropertiesConsumer consumer) {
        ConfigProperties child = new ConfigProperties(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.configProperties(child);
        return (T)this;
    }

    public T configProperties(String childKey) {
        this.configProperties(childKey, null);
        return (T)this;
    }

    public T configProperties(ConfigPropertiesSupplier supplier) {
        this.configProperties(supplier.get());
        return (T)this;
    }

    public T adminObjects(List<AdminObjects> value) {
        this.subresources.adminObjects = value;
        return (T)this;
    }

    public T adminObjects(AdminObjects value) {
        this.subresources.adminObjects.add(value);
        return (T)this;
    }

    public T adminObjects(String childKey, AdminObjectsConsumer consumer) {
        AdminObjects child = new AdminObjects(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.adminObjects(child);
        return (T)this;
    }

    public T adminObjects(String childKey) {
        this.adminObjects(childKey, null);
        return (T)this;
    }

    public T adminObjects(AdminObjectsSupplier supplier) {
        this.adminObjects(supplier.get());
        return (T)this;
    }

    public T connectionDefinitions(List<ConnectionDefinitions> value) {
        this.subresources.connectionDefinitions = value;
        return (T)this;
    }

    public T connectionDefinitions(ConnectionDefinitions value) {
        this.subresources.connectionDefinitions.add(value);
        return (T)this;
    }

    public T connectionDefinitions(String childKey, ConnectionDefinitionsConsumer consumer) {
        ConnectionDefinitions child = new ConnectionDefinitions(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connectionDefinitions(child);
        return (T)this;
    }

    public T connectionDefinitions(String childKey) {
        this.connectionDefinitions(childKey, null);
        return (T)this;
    }

    public T connectionDefinitions(ConnectionDefinitionsSupplier supplier) {
        this.connectionDefinitions(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="archive")
    public String archive() {
        return this.archive;
    }

    public T archive(String value) {
        String oldValue = this.archive;
        this.archive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("archive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="beanvalidationgroups")
    public List<String> beanvalidationgroups() {
        return this.beanvalidationgroups;
    }

    public T beanvalidationgroups(List<String> value) {
        List<String> oldValue = this.beanvalidationgroups;
        this.beanvalidationgroups = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("beanvalidationgroups", oldValue, value);
        }
        return (T)this;
    }

    public T beanvalidationgroup(String value) {
        if (this.beanvalidationgroups == null) {
            this.beanvalidationgroups = new ArrayList<String>();
        }
        this.beanvalidationgroups.add(value);
        return (T)this;
    }

    public T beanvalidationgroups(String ... args) {
        this.beanvalidationgroups(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="bootstrap-context")
    public String bootstrapContext() {
        return this.bootstrapContext;
    }

    public T bootstrapContext(String value) {
        String oldValue = this.bootstrapContext;
        this.bootstrapContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bootstrapContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction-support")
    public TransactionSupport transactionSupport() {
        return this.transactionSupport;
    }

    public T transactionSupport(TransactionSupport value) {
        TransactionSupport oldValue = this.transactionSupport;
        this.transactionSupport = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactionSupport", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wm-security")
    public Boolean wmSecurity() {
        return this.wmSecurity;
    }

    public T wmSecurity(Boolean value) {
        Boolean oldValue = this.wmSecurity;
        this.wmSecurity = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wmSecurity", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wm-security-default-groups")
    public List<String> wmSecurityDefaultGroups() {
        return this.wmSecurityDefaultGroups;
    }

    public T wmSecurityDefaultGroups(List<String> value) {
        List<String> oldValue = this.wmSecurityDefaultGroups;
        this.wmSecurityDefaultGroups = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wmSecurityDefaultGroups", oldValue, value);
        }
        return (T)this;
    }

    public T wmSecurityDefaultGroup(String value) {
        if (this.wmSecurityDefaultGroups == null) {
            this.wmSecurityDefaultGroups = new ArrayList<String>();
        }
        this.wmSecurityDefaultGroups.add(value);
        return (T)this;
    }

    public T wmSecurityDefaultGroups(String ... args) {
        this.wmSecurityDefaultGroups(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wm-security-default-principal")
    public String wmSecurityDefaultPrincipal() {
        return this.wmSecurityDefaultPrincipal;
    }

    public T wmSecurityDefaultPrincipal(String value) {
        String oldValue = this.wmSecurityDefaultPrincipal;
        this.wmSecurityDefaultPrincipal = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wmSecurityDefaultPrincipal", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wm-security-domain")
    public String wmSecurityDomain() {
        return this.wmSecurityDomain;
    }

    public T wmSecurityDomain(String value) {
        String oldValue = this.wmSecurityDomain;
        this.wmSecurityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wmSecurityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wm-security-mapping-groups")
    public List<Map> wmSecurityMappingGroups() {
        return this.wmSecurityMappingGroups;
    }

    public T wmSecurityMappingGroups(List<Map> value) {
        List<Map> oldValue = this.wmSecurityMappingGroups;
        this.wmSecurityMappingGroups = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wmSecurityMappingGroups", oldValue, value);
        }
        return (T)this;
    }

    public T wmSecurityMappingGroup(Map value) {
        if (this.wmSecurityMappingGroups == null) {
            this.wmSecurityMappingGroups = new ArrayList<Map>();
        }
        this.wmSecurityMappingGroups.add(value);
        return (T)this;
    }

    public T wmSecurityMappingGroups(Map ... args) {
        this.wmSecurityMappingGroups(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wm-security-mapping-required")
    public Boolean wmSecurityMappingRequired() {
        return this.wmSecurityMappingRequired;
    }

    public T wmSecurityMappingRequired(Boolean value) {
        Boolean oldValue = this.wmSecurityMappingRequired;
        this.wmSecurityMappingRequired = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wmSecurityMappingRequired", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wm-security-mapping-users")
    public List<Map> wmSecurityMappingUsers() {
        return this.wmSecurityMappingUsers;
    }

    public T wmSecurityMappingUsers(List<Map> value) {
        List<Map> oldValue = this.wmSecurityMappingUsers;
        this.wmSecurityMappingUsers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wmSecurityMappingUsers", oldValue, value);
        }
        return (T)this;
    }

    public T wmSecurityMappingUser(Map value) {
        if (this.wmSecurityMappingUsers == null) {
            this.wmSecurityMappingUsers = new ArrayList<Map>();
        }
        this.wmSecurityMappingUsers.add(value);
        return (T)this;
    }

    public T wmSecurityMappingUsers(Map ... args) {
        this.wmSecurityMappingUsers(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    public static enum TransactionSupport {
        NOTRANSACTION("NoTransaction"),
        LOCALTRANSACTION("LocalTransaction"),
        XATRANSACTION("XATransaction");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private TransactionSupport(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class ResourceAdapterResources {
        @ResourceDocumentation(value="A custom defined config property.")
        @SubresourceInfo(value="configProperties")
        private List<ConfigProperties> configProperties = new ArrayList<ConfigProperties>();
        @ResourceDocumentation(value="Specifies an administration object.")
        @SubresourceInfo(value="adminObjects")
        private List<AdminObjects> adminObjects = new ArrayList<AdminObjects>();
        @ResourceDocumentation(value="Specifies a connection definition.")
        @SubresourceInfo(value="connectionDefinitions")
        private List<ConnectionDefinitions> connectionDefinitions = new ArrayList<ConnectionDefinitions>();

        @Subresource
        public List<ConfigProperties> configProperties() {
            return this.configProperties;
        }

        public ConfigProperties configProperties(String key) {
            return this.configProperties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<AdminObjects> adminObjects() {
            return this.adminObjects;
        }

        public AdminObjects adminObjects(String key) {
            return this.adminObjects.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ConnectionDefinitions> connectionDefinitions() {
            return this.connectionDefinitions;
        }

        public ConnectionDefinitions connectionDefinitions(String key) {
            return this.connectionDefinitions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

