/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModule;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModuleSupplier;

@Address(value="/subsystem=security/security-domain=*/audit=classic")
@ResourceType(value="audit")
@Implicit
public class ClassicAudit<T extends ClassicAudit<T>>
extends HashMap
implements Keyed {
    private String key = "classic";
    private PropertyChangeSupport pcs;
    private ClassicAuditResources subresources = new ClassicAuditResources();

    public ClassicAudit() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassicAuditResources subresources() {
        return this.subresources;
    }

    public T providerModules(List<ProviderModule> value) {
        this.subresources.providerModules = value;
        return (T)this;
    }

    public T providerModule(ProviderModule value) {
        this.subresources.providerModules.add(value);
        return (T)this;
    }

    public T providerModule(String childKey, ProviderModuleConsumer consumer) {
        ProviderModule child = new ProviderModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.providerModule(child);
        return (T)this;
    }

    public T providerModule(String childKey) {
        this.providerModule(childKey, null);
        return (T)this;
    }

    public T providerModule(ProviderModuleSupplier supplier) {
        this.providerModule(supplier.get());
        return (T)this;
    }

    public static class ClassicAuditResources {
        @ResourceDocumentation(value="List of modules that map principal, role, and credential information")
        @SubresourceInfo(value="providerModule")
        private List<ProviderModule> providerModules = new ArrayList<ProviderModule>();

        @Subresource
        public List<ProviderModule> providerModules() {
            return this.providerModules;
        }

        public ProviderModule providerModule(String key) {
            return this.providerModules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

