/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.transactions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=transactions/commit-markable-resource=*")
@ResourceType(value="commit-markable-resource")
public class CommitMarkableResource<T extends CommitMarkableResource<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Batch size for this CMR resource")
    private Integer batchSize;
    @AttributeDocumentation(value="Immediate cleanup associated to this CMR resource")
    private Boolean immediateCleanup;
    @AttributeDocumentation(value="JNDi name of this CMR resource")
    private String jndiName;
    @AttributeDocumentation(value="table name for storing XIDs")
    private String name;

    public CommitMarkableResource(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="batch-size")
    public Integer batchSize() {
        return this.batchSize;
    }

    public T batchSize(Integer value) {
        Integer oldValue = this.batchSize;
        this.batchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("batchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="immediate-cleanup")
    public Boolean immediateCleanup() {
        return this.immediateCleanup;
    }

    public T immediateCleanup(Boolean value) {
        Boolean oldValue = this.immediateCleanup;
        this.immediateCleanup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("immediateCleanup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }
}

