/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.transactions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.transactions.log_store.Transactions;
import org.wildfly.swarm.config.transactions.log_store.TransactionsConsumer;
import org.wildfly.swarm.config.transactions.log_store.TransactionsSupplier;

@Address(value="/subsystem=transactions/log-store=log-store")
@ResourceType(value="log-store")
@Implicit
public class LogStore<T extends LogStore<T>>
extends HashMap
implements Keyed {
    private String key = "log-store";
    private PropertyChangeSupport pcs;
    private LogStoreResources subresources = new LogStoreResources();
    @AttributeDocumentation(value="Whether to expose all logs like orphans etc. By default only a subset of transaction logs is exposed.")
    private Boolean exposeAllLogs;
    @AttributeDocumentation(value="Specifies the implementation type of the logging store.")
    private String type;

    public LogStore() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public LogStoreResources subresources() {
        return this.subresources;
    }

    public T transactions(List<Transactions> value) {
        this.subresources.transactions = value;
        return (T)this;
    }

    public T transactions(Transactions value) {
        this.subresources.transactions.add(value);
        return (T)this;
    }

    public T transactions(String childKey, TransactionsConsumer consumer) {
        Transactions child = new Transactions(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.transactions(child);
        return (T)this;
    }

    public T transactions(String childKey) {
        this.transactions(childKey, null);
        return (T)this;
    }

    public T transactions(TransactionsSupplier supplier) {
        this.transactions(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="expose-all-logs")
    public Boolean exposeAllLogs() {
        return this.exposeAllLogs;
    }

    public T exposeAllLogs(Boolean value) {
        Boolean oldValue = this.exposeAllLogs;
        this.exposeAllLogs = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exposeAllLogs", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }

    public static class LogStoreResources {
        @ResourceDocumentation(value="The persistent information that the transaction manager stores for the purpose of recovering a transaction in the event of failure. The probe operation will add and remove transactions from the model as the corresponding real transactions start and finish the prepare and commit phases. A stuck transaction will remain in the model until either it is completed or explicitly removed by the delete operation.")
        @SubresourceInfo(value="transactions")
        private List<Transactions> transactions = new ArrayList<Transactions>();

        @Subresource
        public List<Transactions> transactions() {
            return this.transactions;
        }

        public Transactions transactions(String key) {
            return this.transactions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

