/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.servlet_container.CrawlerSessionManagementSetting;
import org.wildfly.swarm.config.undertow.servlet_container.CrawlerSessionManagementSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.CrawlerSessionManagementSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSetting;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMapping;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMappingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMappingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSetting;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileSupplier;

@Address(value="/subsystem=undertow/servlet-container=*")
@ResourceType(value="servlet-container")
public class ServletContainer<T extends ServletContainer<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ServletContainerResources subresources = new ServletContainerResources();
    @AttributeDocumentation(value="If true then request and response wrappers that do not extend the standard wrapper classes can be used")
    private Boolean allowNonStandardWrappers;
    @AttributeDocumentation(value="The buffer cache to use for caching static resources")
    private String defaultBufferCache;
    @AttributeDocumentation(value="Default encoding to use for all deployed applications")
    private String defaultEncoding;
    @AttributeDocumentation(value="The default session timeout (in minutes) for all applications deployed in the container.")
    private Integer defaultSessionTimeout;
    @AttributeDocumentation(value="If directory listing should be enabled for default servlets.")
    private Boolean directoryListing;
    @AttributeDocumentation(value="If Undertow should set headers to disable caching for secured paged. Disabling this can cause security problems, as sensitive pages may be cached by an intermediary.")
    private Boolean disableCachingForSecuredPages;
    @AttributeDocumentation(value="If true undertow calls filter init() on deployment start rather than when first requested.")
    private Boolean eagerFilterInitialization;
    @AttributeDocumentation(value="Ignore flushes on the servlet output stream. In most cases these just hurt performance for no good reason.")
    private Boolean ignoreFlush;
    @AttributeDocumentation(value="The maximum number of sessions that can be active at one time")
    private Integer maxSessions;
    @AttributeDocumentation(value="If proactive authentication should be used. If this is true a user will always be authenticated if credentials are present.")
    private Boolean proactiveAuthentication;
    @AttributeDocumentation(value="The length of the generated session ID. Longer session ID's are more secure.")
    private Integer sessionIdLength;
    @AttributeDocumentation(value="If an error page with the stack trace should be generated on error. Values are all, none and local-only")
    private StackTraceOnError stackTraceOnError;
    @AttributeDocumentation(value="Use encoding defined on listener")
    private Boolean useListenerEncoding;

    public ServletContainer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ServletContainerResources subresources() {
        return this.subresources;
    }

    public T mimeMappings(List<MimeMapping> value) {
        this.subresources.mimeMappings = value;
        return (T)this;
    }

    public T mimeMapping(MimeMapping value) {
        this.subresources.mimeMappings.add(value);
        return (T)this;
    }

    public T mimeMapping(String childKey, MimeMappingConsumer consumer) {
        MimeMapping child = new MimeMapping(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.mimeMapping(child);
        return (T)this;
    }

    public T mimeMapping(String childKey) {
        this.mimeMapping(childKey, null);
        return (T)this;
    }

    public T mimeMapping(MimeMappingSupplier supplier) {
        this.mimeMapping(supplier.get());
        return (T)this;
    }

    public T welcomeFiles(List<WelcomeFile> value) {
        this.subresources.welcomeFiles = value;
        return (T)this;
    }

    public T welcomeFile(WelcomeFile value) {
        this.subresources.welcomeFiles.add(value);
        return (T)this;
    }

    public T welcomeFile(String childKey, WelcomeFileConsumer consumer) {
        WelcomeFile child = new WelcomeFile(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.welcomeFile(child);
        return (T)this;
    }

    public T welcomeFile(String childKey) {
        this.welcomeFile(childKey, null);
        return (T)this;
    }

    public T welcomeFile(WelcomeFileSupplier supplier) {
        this.welcomeFile(supplier.get());
        return (T)this;
    }

    public T persistentSessionsSetting(PersistentSessionsSetting value) {
        this.subresources.persistentSessionsSetting = value;
        return (T)this;
    }

    public T persistentSessionsSetting(PersistentSessionsSettingConsumer consumer) {
        PersistentSessionsSetting child = new PersistentSessionsSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.persistentSessionsSetting = child;
        return (T)this;
    }

    public T persistentSessionsSetting() {
        PersistentSessionsSetting child = new PersistentSessionsSetting();
        this.subresources.persistentSessionsSetting = child;
        return (T)this;
    }

    public T persistentSessionsSetting(PersistentSessionsSettingSupplier supplier) {
        this.subresources.persistentSessionsSetting = supplier.get();
        return (T)this;
    }

    public T crawlerSessionManagementSetting(CrawlerSessionManagementSetting value) {
        this.subresources.crawlerSessionManagementSetting = value;
        return (T)this;
    }

    public T crawlerSessionManagementSetting(CrawlerSessionManagementSettingConsumer consumer) {
        CrawlerSessionManagementSetting child = new CrawlerSessionManagementSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.crawlerSessionManagementSetting = child;
        return (T)this;
    }

    public T crawlerSessionManagementSetting() {
        CrawlerSessionManagementSetting child = new CrawlerSessionManagementSetting();
        this.subresources.crawlerSessionManagementSetting = child;
        return (T)this;
    }

    public T crawlerSessionManagementSetting(CrawlerSessionManagementSettingSupplier supplier) {
        this.subresources.crawlerSessionManagementSetting = supplier.get();
        return (T)this;
    }

    public T jspSetting(JSPSetting value) {
        this.subresources.jspSetting = value;
        return (T)this;
    }

    public T jspSetting(JSPSettingConsumer consumer) {
        JSPSetting child = new JSPSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.jspSetting = child;
        return (T)this;
    }

    public T jspSetting() {
        JSPSetting child = new JSPSetting();
        this.subresources.jspSetting = child;
        return (T)this;
    }

    public T jspSetting(JSPSettingSupplier supplier) {
        this.subresources.jspSetting = supplier.get();
        return (T)this;
    }

    public T websocketsSetting(WebsocketsSetting value) {
        this.subresources.websocketsSetting = value;
        return (T)this;
    }

    public T websocketsSetting(WebsocketsSettingConsumer consumer) {
        WebsocketsSetting child = new WebsocketsSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.websocketsSetting = child;
        return (T)this;
    }

    public T websocketsSetting() {
        WebsocketsSetting child = new WebsocketsSetting();
        this.subresources.websocketsSetting = child;
        return (T)this;
    }

    public T websocketsSetting(WebsocketsSettingSupplier supplier) {
        this.subresources.websocketsSetting = supplier.get();
        return (T)this;
    }

    public T sessionCookieSetting(SessionCookieSetting value) {
        this.subresources.sessionCookieSetting = value;
        return (T)this;
    }

    public T sessionCookieSetting(SessionCookieSettingConsumer consumer) {
        SessionCookieSetting child = new SessionCookieSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.sessionCookieSetting = child;
        return (T)this;
    }

    public T sessionCookieSetting() {
        SessionCookieSetting child = new SessionCookieSetting();
        this.subresources.sessionCookieSetting = child;
        return (T)this;
    }

    public T sessionCookieSetting(SessionCookieSettingSupplier supplier) {
        this.subresources.sessionCookieSetting = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-non-standard-wrappers")
    public Boolean allowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public T allowNonStandardWrappers(Boolean value) {
        Boolean oldValue = this.allowNonStandardWrappers;
        this.allowNonStandardWrappers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowNonStandardWrappers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-buffer-cache")
    public String defaultBufferCache() {
        return this.defaultBufferCache;
    }

    public T defaultBufferCache(String value) {
        String oldValue = this.defaultBufferCache;
        this.defaultBufferCache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultBufferCache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-encoding")
    public String defaultEncoding() {
        return this.defaultEncoding;
    }

    public T defaultEncoding(String value) {
        String oldValue = this.defaultEncoding;
        this.defaultEncoding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultEncoding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-session-timeout")
    public Integer defaultSessionTimeout() {
        return this.defaultSessionTimeout;
    }

    public T defaultSessionTimeout(Integer value) {
        Integer oldValue = this.defaultSessionTimeout;
        this.defaultSessionTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSessionTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="directory-listing")
    public Boolean directoryListing() {
        return this.directoryListing;
    }

    public T directoryListing(Boolean value) {
        Boolean oldValue = this.directoryListing;
        this.directoryListing = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("directoryListing", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disable-caching-for-secured-pages")
    public Boolean disableCachingForSecuredPages() {
        return this.disableCachingForSecuredPages;
    }

    public T disableCachingForSecuredPages(Boolean value) {
        Boolean oldValue = this.disableCachingForSecuredPages;
        this.disableCachingForSecuredPages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disableCachingForSecuredPages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="eager-filter-initialization")
    public Boolean eagerFilterInitialization() {
        return this.eagerFilterInitialization;
    }

    public T eagerFilterInitialization(Boolean value) {
        Boolean oldValue = this.eagerFilterInitialization;
        this.eagerFilterInitialization = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("eagerFilterInitialization", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ignore-flush")
    public Boolean ignoreFlush() {
        return this.ignoreFlush;
    }

    public T ignoreFlush(Boolean value) {
        Boolean oldValue = this.ignoreFlush;
        this.ignoreFlush = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ignoreFlush", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-sessions")
    public Integer maxSessions() {
        return this.maxSessions;
    }

    public T maxSessions(Integer value) {
        Integer oldValue = this.maxSessions;
        this.maxSessions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxSessions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="proactive-authentication")
    public Boolean proactiveAuthentication() {
        return this.proactiveAuthentication;
    }

    public T proactiveAuthentication(Boolean value) {
        Boolean oldValue = this.proactiveAuthentication;
        this.proactiveAuthentication = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("proactiveAuthentication", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="session-id-length")
    public Integer sessionIdLength() {
        return this.sessionIdLength;
    }

    public T sessionIdLength(Integer value) {
        Integer oldValue = this.sessionIdLength;
        this.sessionIdLength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sessionIdLength", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stack-trace-on-error")
    public StackTraceOnError stackTraceOnError() {
        return this.stackTraceOnError;
    }

    public T stackTraceOnError(StackTraceOnError value) {
        StackTraceOnError oldValue = this.stackTraceOnError;
        this.stackTraceOnError = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stackTraceOnError", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-listener-encoding")
    public Boolean useListenerEncoding() {
        return this.useListenerEncoding;
    }

    public T useListenerEncoding(Boolean value) {
        Boolean oldValue = this.useListenerEncoding;
        this.useListenerEncoding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useListenerEncoding", oldValue, value);
        }
        return (T)this;
    }

    public static enum StackTraceOnError {
        NONE("none"),
        LOCAL_ONLY("local-only"),
        ALL("all");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private StackTraceOnError(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class ServletContainerResources {
        @ResourceDocumentation(value="The servlet container mime mapping config")
        @SubresourceInfo(value="mimeMapping")
        private List<MimeMapping> mimeMappings = new ArrayList<MimeMapping>();
        @ResourceDocumentation(value="The welcome file")
        @SubresourceInfo(value="welcomeFile")
        private List<WelcomeFile> welcomeFiles = new ArrayList<WelcomeFile>();
        @SingletonResource
        @ResourceDocumentation(value="Session persistence sessions")
        private PersistentSessionsSetting persistentSessionsSetting;
        @SingletonResource
        @ResourceDocumentation(value="Configures special session handing for crawler bots")
        private CrawlerSessionManagementSetting crawlerSessionManagementSetting;
        @SingletonResource
        @ResourceDocumentation(value="JSP container configuration.")
        private JSPSetting jspSetting;
        @SingletonResource
        @ResourceDocumentation(value="If websockets are enabled for this container")
        private WebsocketsSetting websocketsSetting;
        @SingletonResource
        @ResourceDocumentation(value="Session cookie configuration")
        private SessionCookieSetting sessionCookieSetting;

        @Subresource
        public List<MimeMapping> mimeMappings() {
            return this.mimeMappings;
        }

        public MimeMapping mimeMapping(String key) {
            return this.mimeMappings.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<WelcomeFile> welcomeFiles() {
            return this.welcomeFiles;
        }

        public WelcomeFile welcomeFile(String key) {
            return this.welcomeFiles.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public PersistentSessionsSetting persistentSessionsSetting() {
            return this.persistentSessionsSetting;
        }

        @Subresource
        public CrawlerSessionManagementSetting crawlerSessionManagementSetting() {
            return this.crawlerSessionManagementSetting;
        }

        @Subresource
        public JSPSetting jspSetting() {
            return this.jspSetting;
        }

        @Subresource
        public WebsocketsSetting websocketsSetting() {
            return this.websocketsSetting;
        }

        @Subresource
        public SessionCookieSetting sessionCookieSetting() {
            return this.sessionCookieSetting;
        }
    }
}

