/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.weld.bean.proxy.ProxiedMethodFilter;
import org.jboss.weld.util.reflection.Reflections;

final class CommonProxiedMethodFilters {
    static final ProxiedMethodFilter NON_STATIC = new AbstractProxiedMethodFilter(){

        @Override
        public boolean accept(Method method) {
            return !Modifier.isStatic(method.getModifiers());
        }
    };
    static final ProxiedMethodFilter NON_FINAL = new AbstractProxiedMethodFilter(){

        @Override
        public boolean accept(Method method) {
            return !Modifier.isFinal(method.getModifiers());
        }
    };
    static final ProxiedMethodFilter OBJECT_TO_STRING = new AbstractProxiedMethodFilter(){

        @Override
        public boolean accept(Method method) {
            return method.getDeclaringClass() != Object.class || method.getName().equals("toString");
        }
    };
    static final ProxiedMethodFilter NON_PRIVATE = new AbstractProxiedMethodFilter(){

        @Override
        public boolean accept(Method method) {
            return !Modifier.isPrivate(method.getModifiers());
        }
    };
    static final ProxiedMethodFilter NON_JDK_PACKAGE_PRIVATE = new AbstractProxiedMethodFilter(){

        @Override
        public boolean accept(Method method) {
            Package pack;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != null && (pack = declaringClass.getPackage()) != null && pack.getName().startsWith("java")) {
                Class<?>[] parameterTypes;
                if (Reflections.isPackagePrivate(method.getModifiers())) {
                    return false;
                }
                for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                    if (!Reflections.isPackagePrivate(parameterType.getModifiers())) continue;
                    return false;
                }
            }
            return true;
        }
    };

    private CommonProxiedMethodFilters() {
    }

    private static abstract class AbstractProxiedMethodFilter
    implements ProxiedMethodFilter {
        private AbstractProxiedMethodFilter() {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

