/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa.parsing;

public enum JPAVersion {
    V1_0(1, 0),
    V2_0(2, 0),
    V2_1(2, 1);

    public final byte major;
    public final byte minor;

    private JPAVersion(byte major, byte minor) {
        this.major = major;
        this.minor = minor;
    }

    public String getVersion() {
        return String.format("%d.%d", this.major, this.minor);
    }

    public String getFilename() {
        return String.format("persistence_%d_%d.xsd", this.major, this.minor);
    }

    public static JPAVersion parse(String version) {
        return JPAVersion.valueOf("V" + version.charAt(0) + '_' + version.charAt(2));
    }

    public String toString() {
        return String.format("%d_%d", this.major, this.minor);
    }
}

