/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import java.util.Map;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.component.twitter.TwitterComponent;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.impl.verifier.DefaultComponentVerifier;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.impl.verifier.ResultErrorHelper;
import twitter4j.Twitter;
import twitter4j.TwitterException;

final class TwitterComponentVerifier
extends DefaultComponentVerifier {
    TwitterComponentVerifier(TwitterComponent component) {
        super("twitter", component.getCamelContext());
    }

    protected ComponentVerifier.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"accessToken", parameters)).error(ResultErrorHelper.requiresOption((String)"accessTokenSecret", parameters)).error(ResultErrorHelper.requiresOption((String)"consumerKey", parameters)).error(ResultErrorHelper.requiresOption((String)"consumerSecret", parameters));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifier.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) throws Exception {
        try {
            TwitterConfiguration configuration = (TwitterConfiguration)this.setProperties(new TwitterConfiguration(), parameters);
            Twitter twitter = configuration.getTwitter();
            twitter.verifyCredentials();
        }
        catch (TwitterException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifier.VerificationError.Code)ComponentVerifier.VerificationError.StandardCode.AUTHENTICATION, (String)e.getErrorMessage()).detail("twitter_error_code", (Object)e.getErrorCode()).detail("twitter_status_code", (Object)e.getStatusCode()).detail("twitter_exception_code", (Object)e.getExceptionCode()).detail("twitter_exception_message", (Object)e.getMessage()).detail("twitter_exception_caused-by-network-issue", (Object)e.isCausedByNetworkIssue()).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)((Object)((Object)e)).getClass().getName()).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            if (e.getErrorCode() == 89) {
                errorBuilder.parameterKey("accessToken");
            }
            builder.error(errorBuilder.build());
        }
    }
}

