/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.twitter.TwitterComponent;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.TwitterHelper;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.component.twitter.consumer.TwitterConsumerPolling;
import org.apache.camel.component.twitter.data.EndpointType;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@ManagedResource(description="Managed Twitter Endpoint")
@UriEndpoint(firstVersion="2.10.0", scheme="twitter", title="Twitter", syntax="twitter:kind", consumerClass=TwitterConsumer.class, label="api,social")
public class TwitterEndpointPolling
extends DefaultPollingEndpoint
implements TwitterEndpoint {
    @UriParam(optionalPrefix="consumer.", defaultValue="30000", label="consumer,scheduler", description="Milliseconds before the next poll.")
    private long delay = 30000L;
    @UriParam
    private TwitterConfiguration properties;

    public TwitterEndpointPolling(String uri, TwitterComponent component, TwitterConfiguration properties) {
        super(uri, (Component)component);
        this.setDelay(this.delay);
        this.properties = properties;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        TwitterConsumer twitter4jConsumer = TwitterHelper.createConsumer(this, this.getEndpointUri());
        twitter4jConsumer.setLastId(this.properties.getSinceId());
        TwitterConsumerPolling tc = new TwitterConsumerPolling(this, processor, twitter4jConsumer);
        this.configureConsumer((Consumer)tc);
        return tc;
    }

    public Producer createProducer() throws Exception {
        return TwitterHelper.createProducer(this, this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public TwitterConfiguration getProperties() {
        return this.properties;
    }

    public void setProperties(TwitterConfiguration properties) {
        this.properties = properties;
    }

    @ManagedAttribute
    public String getKeywords() {
        return this.getProperties().getKeywords();
    }

    @ManagedAttribute
    public void setKeywords(String keywords) {
        this.getProperties().setKeywords(keywords);
    }

    @ManagedAttribute
    public String getLocations() {
        return this.getProperties().getLocations();
    }

    @ManagedAttribute
    public void setLocations(String locations) {
        this.getProperties().setLocations(locations);
    }

    @ManagedAttribute
    public void setFilterOld(boolean filterOld) {
        this.getProperties().setFilterOld(filterOld);
    }

    @ManagedAttribute
    public boolean isFilterOld() {
        return this.getProperties().isFilterOld();
    }

    @ManagedAttribute
    public void setSinceId(long sinceId) {
        this.getProperties().setSinceId(sinceId);
    }

    @ManagedAttribute
    public long getSinceId() {
        return this.getProperties().getSinceId();
    }

    @ManagedAttribute
    public void setLang(String lang) {
        this.getProperties().setLang(lang);
    }

    @ManagedAttribute
    public String getLang() {
        return this.getProperties().getLang();
    }

    @ManagedAttribute
    public void setCount(Integer count) {
        this.getProperties().setCount(count);
    }

    @ManagedAttribute
    public Integer getCount() {
        return this.getProperties().getCount();
    }

    @ManagedAttribute
    public void setNumberOfPages(Integer numberOfPages) {
        this.getProperties().setNumberOfPages(numberOfPages);
    }

    @ManagedAttribute
    public Integer getNumberOfPages() {
        return this.getProperties().getNumberOfPages();
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.POLLING;
    }

    public void setDelay(long delay) {
        super.setDelay(delay);
        this.delay = delay;
    }
}

