/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.component.twitter.consumer.TwitterEventListener;
import org.apache.camel.component.twitter.consumer.streaming.AbstractStreamingConsumer;
import org.apache.camel.impl.DefaultConsumer;

public class TwitterConsumerEvent
extends DefaultConsumer
implements TwitterEventListener {
    private final TwitterConsumer twitter4jConsumer;

    public TwitterConsumerEvent(TwitterEndpoint endpoint, Processor processor, TwitterConsumer twitter4jConsumer) {
        super((Endpoint)endpoint, processor);
        this.twitter4jConsumer = twitter4jConsumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.twitter4jConsumer instanceof AbstractStreamingConsumer) {
            ((AbstractStreamingConsumer)this.twitter4jConsumer).setEventListener(this);
            ((AbstractStreamingConsumer)this.twitter4jConsumer).start();
        }
    }

    protected void doStop() throws Exception {
        if (this.twitter4jConsumer instanceof AbstractStreamingConsumer) {
            ((AbstractStreamingConsumer)this.twitter4jConsumer).removeEventListener(this);
            ((AbstractStreamingConsumer)this.twitter4jConsumer).stop();
        }
        super.doStop();
    }

    @Override
    public void onEvent(Exchange exchange) {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange on status update", exchange, (Throwable)exchange.getException());
        }
    }
}

