/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer.streaming;

import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.TwitterHelper;
import org.apache.camel.component.twitter.consumer.TwitterEventType;
import org.apache.camel.component.twitter.consumer.streaming.AbstractStreamingConsumer;
import twitter4j.DirectMessage;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserStreamListener;

public class UserStreamingConsumer
extends AbstractStreamingConsumer
implements UserStreamListener {
    public UserStreamingConsumer(TwitterEndpoint endpoint) {
        super(endpoint);
    }

    public void start() {
        this.getTwitterStream().user();
    }

    public void onDeletionNotice(long directMessageId, long userId) {
    }

    public void onFriendList(long[] friendIds) {
    }

    public void onFavorite(User source, User target, Status favoritedStatus) {
        Exchange exchange = TwitterEventType.FAVORITE.createExchange(this.endpoint, favoritedStatus);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, target, "target");
        this.onEvent(exchange);
    }

    public void onUnfavorite(User source, User target, Status unfavoritedStatus) {
        Exchange exchange = TwitterEventType.UNFAVORITE.createExchange(this.endpoint, unfavoritedStatus);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, target, "target");
        this.onEvent(exchange);
    }

    public void onFollow(User source, User followedUser) {
        Exchange exchange = TwitterEventType.FOLLOW.createExchange(this.endpoint);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, followedUser, "followed");
        this.onEvent(exchange);
    }

    public void onUnfollow(User source, User unfollowedUser) {
        Exchange exchange = TwitterEventType.UNFOLLOW.createExchange(this.endpoint);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, unfollowedUser, "unfollowed");
        this.onEvent(exchange);
    }

    public void onDirectMessage(DirectMessage directMessage) {
        this.onEvent(TwitterEventType.DIRECT_MESSAGE.createExchange(this.endpoint, directMessage));
    }

    public void onUserListMemberAddition(User addedMember, User listOwner, UserList list) {
        Exchange exchange = TwitterEventType.USERLIST_MEMBER_ADDITION.createExchange(this.endpoint, list);
        TwitterHelper.setUserHeader(exchange, 1, addedMember, "addedMember");
        TwitterHelper.setUserHeader(exchange, 2, listOwner, "listOwner");
        this.onEvent(exchange);
    }

    public void onUserListMemberDeletion(User deletedMember, User listOwner, UserList list) {
        Exchange exchange = TwitterEventType.USERLIST_MEMBER_DELETION.createExchange(this.endpoint, list);
        TwitterHelper.setUserHeader(exchange, 1, deletedMember, "deletedMember");
        TwitterHelper.setUserHeader(exchange, 2, listOwner, "listOwner");
        this.onEvent(exchange);
    }

    public void onUserListSubscription(User subscriber, User listOwner, UserList list) {
        Exchange exchange = TwitterEventType.USERLIST_SUBSCRIPTION.createExchange(this.endpoint, list);
        TwitterHelper.setUserHeader(exchange, 1, subscriber, "subscriber");
        TwitterHelper.setUserHeader(exchange, 2, listOwner, "listOwner");
        this.onEvent(exchange);
    }

    public void onUserListUnsubscription(User subscriber, User listOwner, UserList list) {
        Exchange exchange = TwitterEventType.USERLIST_UNSUBSCRIPTION.createExchange(this.endpoint, list);
        TwitterHelper.setUserHeader(exchange, 1, subscriber, "subscriber");
        TwitterHelper.setUserHeader(exchange, 2, listOwner, "listOwner");
        this.onEvent(exchange);
    }

    public void onUserListCreation(User user, UserList userList) {
        Exchange exchange = TwitterEventType.USERLIST_CREATION.createExchange(this.endpoint, userList);
        TwitterHelper.setUserHeader(exchange, user);
        this.onEvent(exchange);
    }

    public void onUserListUpdate(User user, UserList userList) {
        Exchange exchange = TwitterEventType.USERLIST_UPDATE.createExchange(this.endpoint, userList);
        TwitterHelper.setUserHeader(exchange, user);
        this.onEvent(exchange);
    }

    public void onUserListDeletion(User user, UserList userList) {
        Exchange exchange = TwitterEventType.USERLIST_DELETETION.createExchange(this.endpoint, userList);
        TwitterHelper.setUserHeader(exchange, user);
        this.onEvent(exchange);
    }

    public void onUserProfileUpdate(User user) {
        Exchange exchange = TwitterEventType.USER_PROFILE_UPDATE.createExchange(this.endpoint);
        TwitterHelper.setUserHeader(exchange, user);
        this.onEvent(exchange);
    }

    public void onUserSuspension(long suspendedUser) {
        Exchange exchange = TwitterEventType.USER_SUSPENSION.createExchange(this.endpoint);
        exchange.getIn().setHeader("CamelTwitterUser", (Object)suspendedUser);
        this.onEvent(exchange);
    }

    public void onUserDeletion(long deletedUser) {
        Exchange exchange = TwitterEventType.USER_DELETION.createExchange(this.endpoint);
        exchange.getIn().setHeader("CamelTwitterUser", (Object)deletedUser);
        this.onEvent(exchange);
    }

    public void onBlock(User source, User blockedUser) {
        Exchange exchange = TwitterEventType.BLOCK.createExchange(this.endpoint);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, blockedUser, "blocked");
        this.onEvent(exchange);
    }

    public void onUnblock(User source, User unblockedUser) {
        Exchange exchange = TwitterEventType.UNBLOCK.createExchange(this.endpoint);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, unblockedUser, "unblocked");
        this.onEvent(exchange);
    }

    public void onStallWarning(StallWarning stallWarning) {
    }

    public void onRetweetedRetweet(User source, User target, Status retweetedStatus) {
        Exchange exchange = TwitterEventType.RETWEETED_RETWEET.createExchange(this.endpoint, retweetedStatus);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, target, "target");
        this.onEvent(exchange);
    }

    public void onFavoritedRetweet(User source, User target, Status favoritedRetweeet) {
        Exchange exchange = TwitterEventType.FAVORITED_RETWEET.createExchange(this.endpoint, favoritedRetweeet);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, target, "target");
        this.onEvent(exchange);
    }

    public void onQuotedTweet(User source, User target, Status quotingTweet) {
        Exchange exchange = TwitterEventType.QUOTED_TWEET.createExchange(this.endpoint, quotingTweet);
        TwitterHelper.setUserHeader(exchange, 1, source, "source");
        TwitterHelper.setUserHeader(exchange, 2, target, "target");
        this.onEvent(exchange);
    }
}

