/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.component.undertow.DefaultUndertowHost;
import org.apache.camel.component.undertow.RestUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowComponentVerifier;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.UndertowHostKey;
import org.apache.camel.component.undertow.UndertowHostOptions;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowRestHeaderFilterStrategy;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="verifiers", enums="parameters,connectivity")
public class UndertowComponent
extends DefaultComponent
implements RestConsumerFactory,
RestApiConsumerFactory,
RestProducerFactory,
VerifiableComponent,
SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowEndpoint.class);
    private Map<UndertowHostKey, UndertowHost> undertowRegistry = new ConcurrentHashMap<UndertowHostKey, UndertowHost>();
    @Metadata(label="advanced")
    private UndertowHttpBinding undertowHttpBinding;
    @Metadata(label="security")
    private SSLContextParameters sslContextParameters;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="advanced")
    private UndertowHostOptions hostOptions;

    public UndertowComponent() {
    }

    public UndertowComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI uriHttpUriAddress = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, parameters);
        Map options = IntrospectionSupport.extractProperties(parameters, (String)"option.");
        SSLContextParameters sslParams = this.sslContextParameters;
        if (sslParams == null) {
            sslParams = this.retrieveGlobalSslContextParameters();
        }
        UndertowEndpoint endpoint = this.createEndpointInstance(endpointUri, this);
        endpoint.setSslContextParameters(sslParams);
        if (this.undertowHttpBinding == null) {
            this.undertowHttpBinding = this.getUndertowHttpBinding();
        }
        if (this.undertowHttpBinding != null) {
            endpoint.setUndertowHttpBinding(this.undertowHttpBinding);
        }
        this.setProperties((Object)endpoint, parameters);
        if (options != null) {
            endpoint.setOptions(options);
        }
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpURI(httpUri);
        return endpoint;
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new UndertowEndpoint(endpointUri.toString(), component);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        boolean cors;
        String contextPath;
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = camelContext.getRestConfiguration("undertow", true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if ((config.getComponent() == null || config.getComponent().equals("undertow")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (cors = config.isEnableCORS()) {
            map.put("optionsEnabled", "true");
        }
        String query = URISupport.createQueryString(map);
        String url = api ? "undertow:%s://%s:%s/%s?matchOnUriPrefix=true&httpMethodRestrict=%s" : "undertow:%s://%s:%s/%s?httpMethodRestrict=%s";
        String restrict = verb.toUpperCase(Locale.US);
        if (cors) {
            restrict = restrict + ",OPTIONS";
        }
        url = String.format(url, scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        UndertowEndpoint endpoint = (UndertowEndpoint)camelContext.getEndpoint(url, UndertowEndpoint.class);
        this.setProperties(camelContext, (Object)endpoint, parameters);
        if (!map.containsKey("undertowHttpBinding")) {
            endpoint.setUndertowHttpBinding(new RestUndertowHttpBinding());
        }
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, Map<String, Object> parameters) throws Exception {
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String url = "undertow:" + host;
        if (!ObjectHelper.isEmpty((Object)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((Object)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        UndertowEndpoint endpoint = (UndertowEndpoint)camelContext.getEndpoint(url, UndertowEndpoint.class);
        if (parameters != null && !parameters.isEmpty()) {
            this.setProperties(camelContext, (Object)endpoint, parameters);
        }
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new UndertowRestHeaderFilterStrategy(path, queryParameters));
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    protected void doStart() throws Exception {
        super.doStart();
        RestConfiguration config = this.getCamelContext().getRestConfiguration("undertow", true);
        if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties((Object)this, config.getComponentProperties());
        }
    }

    public void registerConsumer(UndertowConsumer consumer) {
        URI uri = consumer.getEndpoint().getHttpURI();
        UndertowHostKey key = new UndertowHostKey(uri.getHost(), uri.getPort(), consumer.getEndpoint().getSslContext());
        UndertowHost host = this.undertowRegistry.get(key);
        if (host == null) {
            host = this.createUndertowHost(key);
            this.undertowRegistry.put(key, host);
        }
        host.validateEndpointURI(uri);
        host.registerHandler(consumer.getHttpHandlerRegistrationInfo(), consumer.getHttpHandler());
    }

    public void unregisterConsumer(UndertowConsumer consumer) {
        URI uri = consumer.getEndpoint().getHttpURI();
        UndertowHostKey key = new UndertowHostKey(uri.getHost(), uri.getPort(), consumer.getEndpoint().getSslContext());
        UndertowHost host = this.undertowRegistry.get(key);
        host.unregisterHandler(consumer.getHttpHandlerRegistrationInfo());
    }

    protected UndertowHost createUndertowHost(UndertowHostKey key) {
        return new DefaultUndertowHost(key, this.hostOptions);
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public UndertowHostOptions getHostOptions() {
        return this.hostOptions;
    }

    public void setHostOptions(UndertowHostOptions hostOptions) {
        this.hostOptions = hostOptions;
    }

    public ComponentVerifier getVerifier() {
        return new UndertowComponentVerifier(this);
    }
}

