/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import java.util.Iterator;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.monitor.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.Monitor;

@Vetoed
class Queries {
    protected Queries() {
    }

    public static final boolean isSecuredHealthEndpoint(Monitor monitor, String relativePath) {
        return Queries.query(monitor, metaData -> relativePath.equals("/health" + metaData.getWebContext()) && metaData.isSecure());
    }

    public static final boolean isAggregatorEndpoint(Monitor monitor, String relativePath) {
        return Queries.query(monitor, metaData -> relativePath.equals("/health"));
    }

    public static final boolean isDirectAccessToHealthEndpoint(Monitor monitor, String relativePath) {
        return Queries.query(monitor, metaData -> relativePath.equals(metaData.getWebContext()));
    }

    public static final boolean query(Monitor monitor, Condition condition) {
        HealthMetaData metaData;
        boolean isCondition = false;
        Iterator<HealthMetaData> iterator = monitor.getHealthURIs().iterator();
        while (iterator.hasNext() && !(isCondition = condition.eval(metaData = iterator.next()))) {
        }
        return isCondition;
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean eval(HealthMetaData var1);
    }
}

