/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyAbstractDataFormat;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyCsvFactory;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyCsvDataFormat
extends BindyAbstractDataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(BindyCsvDataFormat.class);

    public BindyCsvDataFormat() {
    }

    public BindyCsvDataFormat(Class<?> type) {
        super(type);
    }

    public String getDataFormatName() {
        return "bindy-csv";
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        BindyCsvFactory factory = (BindyCsvFactory)this.getFactory();
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        byte[] bytesCRLF = ConverterUtils.getByteReturn(factory.getCarriageReturn());
        if (factory.getGenerateHeaderColumnNames()) {
            String result = factory.generateHeader();
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
        ArrayList<Map> models = new ArrayList<Map>();
        Iterator it = ObjectHelper.createIterator((Object)body);
        while (it.hasNext()) {
            Object model = it.next();
            if (model instanceof Map) {
                models.add((Map)model);
                continue;
            }
            String name = model.getClass().getName();
            HashMap<String, Object> row = new HashMap<String, Object>(1);
            row.put(name, model);
            row.putAll(this.createLinkedFieldsModel(model));
            models.add(row);
        }
        for (Map model : models) {
            String result = factory.unbind(model);
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
    }

    private boolean checkEmptyStream(BindyCsvFactory factory, InputStream inputStream) throws IOException {
        boolean allowEmptyStream = factory.isAllowEmptyStream();
        boolean isStreamEmpty = false;
        boolean canReturnEmptyListOfModels = false;
        if (inputStream == null || inputStream.available() == 0) {
            isStreamEmpty = true;
        }
        if (isStreamEmpty && allowEmptyStream) {
            canReturnEmptyListOfModels = true;
        }
        return canReturnEmptyListOfModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        block14: {
            Scanner scanner;
            InputStreamReader in;
            ArrayList<Map<String, Object>> models;
            BindyCsvFactory factory;
            block12: {
                ArrayList<Map<String, Object>> arrayList;
                block13: {
                    factory = (BindyCsvFactory)this.getFactory();
                    ObjectHelper.notNull((Object)factory, (String)"not instantiated");
                    models = new ArrayList<Map<String, Object>>();
                    in = null;
                    scanner = null;
                    if (!this.checkEmptyStream(factory, inputStream)) break block12;
                    arrayList = models;
                    if (scanner != null) {
                        scanner.close();
                    }
                    if (in == null) break block13;
                    IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
                }
                return arrayList;
            }
            try {
                in = new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange));
                scanner = new Scanner(in);
                String separator = factory.getSeparator();
                String quote = factory.getQuote();
                ObjectHelper.notNull((Object)separator, (String)"The separator has not been defined in the annotation @CsvRecord or not instantiated during initModel.");
                int count = 0;
                if (factory.getSkipFirstLine() && scanner.hasNextLine()) {
                    scanner.nextLine();
                }
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (ObjectHelper.isEmpty((Object)line)) continue;
                    ++count;
                    Map<String, Object> model = factory.factory();
                    String[] tokens = line.split(separator, factory.getAutospanLine() ? factory.getMaxpos() : -1);
                    List<String> result = Arrays.asList(tokens);
                    if ((result = this.unquoteTokens(result, separator, quote)).size() == 0 || result.isEmpty()) {
                        throw new IllegalArgumentException("No records have been defined in the CSV");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Size of the record splitted : {}", (Object)result.size());
                    }
                    factory.bind(result, model, count);
                    factory.link(model);
                    models.add(model);
                    LOG.debug("Graph of objects created: {}", model);
                }
                if (models.size() == 0) {
                    throw new IllegalArgumentException("No records have been defined in the CSV");
                }
                object = this.extractUnmarshalResult(models);
                if (scanner != null) {
                    scanner.close();
                }
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    scanner.close();
                }
                if (in != null) {
                    IOHelper.close(in, (String)"in", (Logger)LOG);
                }
                throw throwable;
            }
            IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
        }
        return object;
    }

    private List<String> unquoteTokens(List<String> result, String separator, String quote) {
        StringBuilder current = new StringBuilder();
        boolean inProgress = false;
        ArrayList<String> answer = new ArrayList<String>();
        for (String s : result) {
            boolean canStart = false;
            boolean canClose = false;
            boolean cutStart = false;
            boolean cutEnd = false;
            if (s.startsWith(quote)) {
                if (s.length() == 1) {
                    s = "";
                    if (inProgress) {
                        canClose = true;
                    } else {
                        canStart = true;
                    }
                } else {
                    cutStart = true;
                    canStart = true;
                }
            }
            if (s.endsWith(quote)) {
                cutEnd = true;
                canClose = true;
            }
            if (cutEnd || cutStart) {
                s = s.substring(cutStart ? 1 : 0, cutEnd ? s.length() - 1 : s.length());
            }
            if (inProgress) {
                current.append(separator);
                current.append(s);
                if (!canClose) continue;
                answer.add(current.toString());
                current.setLength(0);
                inProgress = false;
                continue;
            }
            if (canStart && !canClose) {
                current.append(s);
                inProgress = true;
                continue;
            }
            answer.add(s);
        }
        if (current.length() > 0) {
            answer.add(current.toString());
            current.setLength(0);
        }
        return answer;
    }

    @Override
    protected BindyAbstractFactory createModelFactory(FormatFactory formatFactory) throws Exception {
        BindyCsvFactory bindyCsvFactory = new BindyCsvFactory(this.getClassType());
        bindyCsvFactory.setFormatFactory(formatFactory);
        return bindyCsvFactory;
    }
}

