/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.NumberPatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class FloatPatternFormatFactory
extends AbstractFormatFactory {
    public FloatPatternFormatFactory() {
        this.supportedClasses.add(Float.TYPE);
        this.supportedClasses.add(Float.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isNotEmpty((Object)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new FloatPatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale());
    }

    private static class FloatPatternFormat
    extends NumberPatternFormat<Float> {
        FloatPatternFormat(String pattern, Locale locale) {
            super(pattern, locale);
        }

        @Override
        public Float parse(String string) throws Exception {
            if (this.getNumberFormat() != null) {
                return Float.valueOf(this.getNumberFormat().parse(string).floatValue());
            }
            return Float.valueOf(string);
        }
    }
}

