/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.ClassesAuditingData;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.hibernate.envers.configuration.internal.PersistentClassGraphDefiner;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityNameRegister;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityXmlMappingData;
import org.hibernate.envers.configuration.internal.metadata.reader.AnnotationsMetadataReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.graph.GraphTopologicalSort;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;

public class EntitiesConfigurator {
    public EntitiesConfigurations configure(MetadataImplementor metadata, ServiceRegistry serviceRegistry, ReflectionManager reflectionManager, MappingCollector mappingCollector, GlobalConfiguration globalConfiguration, AuditEntitiesConfiguration auditEntitiesConfiguration, AuditStrategy auditStrategy, Document revisionInfoXmlMapping, Element revisionInfoRelationMapping) {
        AuditEntityNameRegister auditEntityNameRegister = new AuditEntityNameRegister();
        Iterator<PersistentClass> classes = GraphTopologicalSort.sort(new PersistentClassGraphDefiner(metadata)).iterator();
        ClassesAuditingData classesAuditingData = new ClassesAuditingData();
        HashMap<PersistentClass, EntityXmlMappingData> xmlMappings = new HashMap<PersistentClass, EntityXmlMappingData>();
        while (classes.hasNext()) {
            PersistentClass pc = classes.next();
            if (pc.getClassName() == null) continue;
            Iterator<Map.Entry<PersistentClass, ClassAuditingData>> annotationsMetadataReader = new AnnotationsMetadataReader(globalConfiguration, reflectionManager, pc);
            ClassAuditingData auditData = ((AnnotationsMetadataReader)((Object)annotationsMetadataReader)).getAuditData();
            classesAuditingData.addClassAuditingData(pc, auditData);
        }
        classesAuditingData.updateCalculatedFields();
        AuditMetadataGenerator auditMetaGen = new AuditMetadataGenerator(metadata, serviceRegistry, globalConfiguration, auditEntitiesConfiguration, auditStrategy, revisionInfoRelationMapping, auditEntityNameRegister);
        for (Map.Entry<PersistentClass, ClassAuditingData> pcDatasEntry : classesAuditingData.getAllClassAuditedData()) {
            PersistentClass pc = (PersistentClass)pcDatasEntry.getKey();
            ClassAuditingData auditData = (ClassAuditingData)pcDatasEntry.getValue();
            EntityXmlMappingData xmlMappingData = new EntityXmlMappingData();
            if (auditData.isAudited()) {
                if (!StringTools.isEmpty(auditData.getAuditTable().value())) {
                    auditEntitiesConfiguration.addCustomAuditTableName(pc.getEntityName(), auditData.getAuditTable().value());
                }
                auditMetaGen.generateFirstPass(pc, auditData, xmlMappingData, true);
            } else {
                auditMetaGen.generateFirstPass(pc, auditData, xmlMappingData, false);
            }
            xmlMappings.put(pc, xmlMappingData);
        }
        for (Map.Entry<PersistentClass, ClassAuditingData> pcDatasEntry : classesAuditingData.getAllClassAuditedData()) {
            EntityXmlMappingData xmlMappingData = (EntityXmlMappingData)xmlMappings.get(pcDatasEntry.getKey());
            if (!pcDatasEntry.getValue().isAudited()) continue;
            auditMetaGen.generateSecondPass(pcDatasEntry.getKey(), pcDatasEntry.getValue(), xmlMappingData);
            try {
                mappingCollector.addDocument(xmlMappingData.getMainXmlMapping());
                for (Document additionalMapping : xmlMappingData.getAdditionalXmlMappings()) {
                    mappingCollector.addDocument(additionalMapping);
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        if (auditMetaGen.getEntitiesConfigurations().size() > 0) {
            try {
                if (revisionInfoXmlMapping != null) {
                    mappingCollector.addDocument(revisionInfoXmlMapping);
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        return new EntitiesConfigurations(auditMetaGen.getEntitiesConfigurations(), auditMetaGen.getNotAuditedEntitiesConfigurations());
    }
}

