/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.mongodb;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.mongodb.mongo.Host;
import org.wildfly.swarm.config.mongodb.mongo.HostConsumer;
import org.wildfly.swarm.config.mongodb.mongo.HostSupplier;
import org.wildfly.swarm.config.mongodb.mongo.Properties;
import org.wildfly.swarm.config.mongodb.mongo.PropertiesConsumer;
import org.wildfly.swarm.config.mongodb.mongo.PropertiesSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=mongodb/mongo=*")
@ResourceType(value="mongo")
public class Mongo<T extends Mongo<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private MongoResources subresources = new MongoResources();
    @AttributeDocumentation(value="MongoDB authorization type")
    private AuthType authType;
    @AttributeDocumentation(value="MongoDB database name")
    private String database;
    @AttributeDocumentation(value="Unique profile identification")
    private String id;
    @AttributeDocumentation(value="JNDI address")
    private String jndiName;
    @AttributeDocumentation(value="Module name")
    private String module;
    @AttributeDocumentation(value="Security domain name")
    private String securityDomain;
    @AttributeDocumentation(value="use SSL for connecting to MongoDB")
    private Boolean ssl;

    public Mongo(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MongoResources subresources() {
        return this.subresources;
    }

    public T hosts(List<Host> value) {
        this.subresources.hosts = value;
        return (T)this;
    }

    public T host(Host value) {
        this.subresources.hosts.add(value);
        return (T)this;
    }

    public T host(String childKey, HostConsumer consumer) {
        Host child = new Host(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.host(child);
        return (T)this;
    }

    public T host(String childKey) {
        this.host(childKey, null);
        return (T)this;
    }

    public T host(HostSupplier supplier) {
        this.host(supplier.get());
        return (T)this;
    }

    public T properties(List<Properties> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T properties(Properties value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T properties(String childKey, PropertiesConsumer consumer) {
        Properties child = new Properties(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.properties(child);
        return (T)this;
    }

    public T properties(String childKey) {
        this.properties(childKey, null);
        return (T)this;
    }

    public T properties(PropertiesSupplier supplier) {
        this.properties(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auth-type")
    public AuthType authType() {
        return this.authType;
    }

    public T authType(AuthType value) {
        AuthType oldValue = this.authType;
        this.authType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="database")
    public String database() {
        return this.database;
    }

    public T database(String value) {
        String oldValue = this.database;
        this.database = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("database", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="id")
    public String id() {
        return this.id;
    }

    public T id(String value) {
        String oldValue = this.id;
        this.id = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("id", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl")
    public Boolean ssl() {
        return this.ssl;
    }

    public T ssl(Boolean value) {
        Boolean oldValue = this.ssl;
        this.ssl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ssl", oldValue, value);
        }
        return (T)this;
    }

    public static enum AuthType {
        GSSAPI("GSSAPI"),
        PLAIN_SASL("PLAIN_SASL"),
        SCRAM_SHA_1("SCRAM_SHA_1"),
        MONGODB_CR("MONGODB_CR"),
        MONGODB_X509("MONGODB_X509"),
        DEFAULT("DEFAULT");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private AuthType(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class MongoResources {
        @ResourceDocumentation(value="Host")
        @SubresourceInfo(value="host")
        private List<Host> hosts = new ArrayList<Host>();
        @ResourceDocumentation(value="Custom MongoDB properties")
        @SubresourceInfo(value="properties")
        private List<Properties> properties = new ArrayList<Properties>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        public Host host(String key) {
            return this.hosts.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Properties> properties() {
            return this.properties;
        }

        public Properties properties(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

