/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.composite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.component.salesforce.api.dto.RestError;

@XStreamAlias(value="results")
public final class ReferenceId
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamImplicit
    private final List<RestError> errors;
    private final String id;
    private final String referenceId;

    @JsonCreator
    ReferenceId(@JsonProperty(value="referenceId") String referenceId, @JsonProperty(value="id") String id, @JsonProperty(value="errors") List<RestError> errors) {
        this.referenceId = referenceId;
        this.id = id;
        this.errors = errors;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReferenceId)) {
            return false;
        }
        ReferenceId other = (ReferenceId)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.getErrors(), other.getErrors());
    }

    public List<RestError> getErrors() {
        return Collections.unmodifiableList(Optional.ofNullable(this.errors).orElse(Collections.emptyList()));
    }

    public String getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.referenceId == null ? 0 : this.referenceId.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder buildy = new StringBuilder("Reference: ").append(this.referenceId).append(", Id: ");
        List<RestError> anyErrors = this.getErrors();
        if (anyErrors.isEmpty()) {
            buildy.append(", with no errors");
        } else {
            buildy.append(", with ");
            buildy.append(anyErrors.size());
            buildy.append(" error(s)");
        }
        return buildy.toString();
    }
}

