/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.AbstractReportResultsBase;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.RecentReport;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportDescription;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportInstance;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.internal.client.AnalyticsApiClient;
import org.apache.camel.component.salesforce.internal.client.DefaultAnalyticsApiClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.util.ServiceHelper;

public class AnalyticsApiProcessor
extends AbstractSalesforceProcessor {
    private AnalyticsApiClient analyticsClient;

    public AnalyticsApiProcessor(SalesforceEndpoint endpoint) throws SalesforceException {
        super(endpoint);
        this.analyticsClient = new DefaultAnalyticsApiClient((String)this.endpointConfigMap.get("apiVersion"), this.session, this.httpClient);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean done = false;
        try {
            switch (this.operationName) {
                case GET_RECENT_REPORTS: {
                    this.processGetRecentReports(exchange, callback);
                    break;
                }
                case GET_REPORT_DESCRIPTION: {
                    this.processGetReportDescription(exchange, callback);
                    break;
                }
                case EXECUTE_SYNCREPORT: {
                    this.processExecuteSyncReport(exchange, callback);
                    break;
                }
                case EXECUTE_ASYNCREPORT: {
                    this.processExecuteAsyncReport(exchange, callback);
                    break;
                }
                case GET_REPORT_INSTANCES: {
                    this.processGetReportInstances(exchange, callback);
                    break;
                }
                case GET_REPORT_RESULTS: {
                    this.processGetReportResults(exchange, callback);
                    break;
                }
                default: {
                    throw new SalesforceException("Unknown operation name: " + this.operationName.value(), null);
                }
            }
        }
        catch (SalesforceException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Error processing %s: [%s] \"%s\"", this.operationName.value(), e.getStatusCode(), e.getMessage()), (Throwable)((Object)e))));
            callback.done(true);
            done = true;
        }
        catch (RuntimeException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e)));
            callback.done(true);
            done = true;
        }
        return done;
    }

    private void processGetRecentReports(final Exchange exchange, final AsyncCallback callback) {
        this.analyticsClient.getRecentReports(new AnalyticsApiClient.RecentReportsResponseCallback(){

            @Override
            public void onResponse(List<RecentReport> reportDescription, SalesforceException ex) {
                AnalyticsApiProcessor.this.processResponse(exchange, reportDescription, ex, callback);
            }
        });
    }

    private void processGetReportDescription(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String reportId = this.getParameter("reportId", exchange, true, false);
        this.analyticsClient.getReportDescription(reportId, new AnalyticsApiClient.ReportDescriptionResponseCallback(){

            @Override
            public void onResponse(ReportDescription reportDescription, SalesforceException ex) {
                AnalyticsApiProcessor.this.processResponse(exchange, reportDescription, ex, callback);
            }
        });
    }

    private void processExecuteSyncReport(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String reportId;
        Boolean includeDetails = this.getParameter("includeDetails", exchange, false, true, Boolean.class);
        ReportMetadata reportMetadata = (ReportMetadata)exchange.getIn().getBody(ReportMetadata.class);
        if (reportMetadata != null) {
            reportId = reportMetadata.getId();
            if (reportId == null) {
                reportId = this.getParameter("reportId", exchange, false, false);
            }
        } else {
            reportId = this.getParameter("reportId", exchange, true, false);
            reportMetadata = this.getParameter("reportMetadata", exchange, false, true, ReportMetadata.class);
        }
        this.analyticsClient.executeSyncReport(reportId, includeDetails, reportMetadata, new AnalyticsApiClient.ReportResultsResponseCallback(){

            @Override
            public void onResponse(AbstractReportResultsBase reportResults, SalesforceException ex) {
                AnalyticsApiProcessor.this.processResponse(exchange, reportResults, ex, callback);
            }
        });
    }

    private void processExecuteAsyncReport(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String reportId;
        Boolean includeDetails = this.getParameter("includeDetails", exchange, false, true, Boolean.class);
        ReportMetadata reportMetadata = (ReportMetadata)exchange.getIn().getBody(ReportMetadata.class);
        if (reportMetadata != null) {
            reportId = reportMetadata.getId();
            if (reportId == null) {
                reportId = this.getParameter("reportId", exchange, false, false);
            }
        } else {
            reportId = this.getParameter("reportId", exchange, true, false);
            reportMetadata = this.getParameter("reportMetadata", exchange, false, true, ReportMetadata.class);
        }
        this.analyticsClient.executeAsyncReport(reportId, includeDetails, reportMetadata, new AnalyticsApiClient.ReportInstanceResponseCallback(){

            @Override
            public void onResponse(ReportInstance reportInstance, SalesforceException ex) {
                AnalyticsApiProcessor.this.processResponse(exchange, reportInstance, ex, callback);
            }
        });
    }

    private void processGetReportInstances(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String reportId = this.getParameter("reportId", exchange, true, false);
        this.analyticsClient.getReportInstances(reportId, new AnalyticsApiClient.ReportInstanceListResponseCallback(){

            @Override
            public void onResponse(List<ReportInstance> reportInstances, SalesforceException ex) {
                AnalyticsApiProcessor.this.processResponse(exchange, reportInstances, ex, callback);
            }
        });
    }

    private void processGetReportResults(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String reportId = this.getParameter("reportId", exchange, true, false);
        String instanceId = this.getParameter("instanceId", exchange, false, false);
        this.analyticsClient.getReportResults(reportId, instanceId, new AnalyticsApiClient.ReportResultsResponseCallback(){

            @Override
            public void onResponse(AbstractReportResultsBase reportResults, SalesforceException ex) {
                AnalyticsApiProcessor.this.processResponse(exchange, reportResults, ex, callback);
            }
        });
    }

    private void processResponse(Exchange exchange, Object body, SalesforceException ex, AsyncCallback callback) {
        Message out = exchange.getOut();
        if (ex != null) {
            exchange.setException((Throwable)((Object)ex));
        } else {
            out.setBody(body);
        }
        out.getHeaders().putAll(exchange.getIn().getHeaders());
        out.getAttachmentObjects().putAll(exchange.getIn().getAttachmentObjects());
        callback.done(false);
    }

    public void start() throws Exception {
        ServiceHelper.startService((Object)this.analyticsClient);
    }

    public void stop() throws Exception {
        ServiceHelper.stopService((Object)this.analyticsClient);
    }
}

