/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Date;
import javax.mail.Message;
import javax.mail.search.ComparisonTerm;

public class NowSearchTerm
extends ComparisonTerm {
    private static final long serialVersionUID = 1L;
    private final int comparison;
    private final boolean sentDate;
    private final long offset;

    public NowSearchTerm(int comparison, boolean sentDate, long offset) {
        this.comparison = comparison;
        this.sentDate = sentDate;
        this.offset = offset;
    }

    private Date getDate() {
        long now = new Date().getTime();
        return new Date(now + this.offset);
    }

    public boolean match(Message msg) {
        Date d;
        try {
            d = this.sentDate ? msg.getSentDate() : msg.getReceivedDate();
        }
        catch (Exception e) {
            return false;
        }
        if (d == null) {
            return false;
        }
        return NowSearchTerm.match(d, this.getDate(), this.comparison);
    }

    private static boolean match(Date d1, Date d2, int comparison) {
        switch (comparison) {
            case 1: {
                return d1.before(d2) || d1.equals(d2);
            }
            case 2: {
                return d1.before(d2);
            }
            case 3: {
                return d1.equals(d2);
            }
            case 4: {
                return !d1.equals(d2);
            }
            case 5: {
                return d1.after(d2);
            }
            case 6: {
                return d1.after(d2) || d1.equals(d2);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NowSearchTerm that = (NowSearchTerm)((Object)o);
        return this.sentDate == that.sentDate;
    }

    public int hashCode() {
        return this.comparison;
    }
}

