/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppSplitter {
    protected static final int UDHIE_HEADER_LENGTH = 5;
    protected static final int UDHIE_HEADER_REAL_LENGTH = 6;
    protected static final int UDHIE_SAR_REF_NUM_LENGTH = 1;
    protected static final byte UDHIE_IDENTIFIER_SAR = 0;
    protected static final byte UDHIE_SAR_LENGTH = 3;
    protected static final int MAX_MSG_BYTE_LENGTH = 140;
    protected static final int MAX_SEG_COUNT = 255;
    private static final Logger LOG = LoggerFactory.getLogger(SmppSplitter.class);
    private static int refNum;
    private int messageLength;
    private int segmentLength;
    private int currentLength;

    protected SmppSplitter(int messageLength, int segmentLength, int currentLength) {
        this.messageLength = messageLength;
        this.segmentLength = segmentLength;
        this.currentLength = currentLength;
    }

    protected static synchronized byte getReferenceNumber() {
        if (++refNum == 256) {
            refNum = 1;
        }
        return (byte)refNum;
    }

    protected static synchronized byte getCurrentReferenceNumber() {
        return (byte)refNum;
    }

    protected static synchronized void resetCurrentReferenceNumber() {
        refNum = 0;
    }

    public byte[][] split(byte[] message) {
        if (!this.isSplitRequired()) {
            return new byte[][]{message};
        }
        int segmentLength = this.getSegmentLength();
        int segmentNum = message.length / segmentLength;
        int messageLength = message.length;
        if (segmentNum > 255) {
            segmentNum = 255;
            messageLength = segmentNum * segmentLength;
        }
        if (messageLength % segmentLength > 0) {
            ++segmentNum;
        }
        byte[][] segments = new byte[segmentNum][];
        byte refNum = SmppSplitter.getReferenceNumber();
        for (int i = 0; i < segmentNum; ++i) {
            LOG.trace("segment number = {}", (Object)i);
            int lengthOfData = segmentNum - i == 1 ? messageLength - i * segmentLength : segmentLength;
            LOG.trace("Length of data = {}", (Object)lengthOfData);
            segments[i] = new byte[6 + lengthOfData];
            LOG.trace("segments[{}].length = {}", (Object)i, (Object)segments[i].length);
            segments[i][0] = 5;
            segments[i][1] = 0;
            segments[i][2] = 3;
            segments[i][3] = refNum;
            segments[i][4] = (byte)segmentNum;
            segments[i][5] = (byte)(i + 1);
            System.arraycopy(message, i * segmentLength, segments[i], 6, lengthOfData);
        }
        return segments;
    }

    protected boolean isSplitRequired() {
        return this.getCurrentLength() > this.getMessageLength();
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public int getCurrentLength() {
        return this.currentLength;
    }
}

