/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ResourceHelper;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelperKeyPairProvider
extends AbstractKeyPairProvider {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ClassResolver classResolver;
    private String[] resources;
    private PasswordFinder passwordFinder;

    public ResourceHelperKeyPairProvider() {
    }

    public ResourceHelperKeyPairProvider(String[] resources, ClassResolver classResolver) {
        this.classResolver = classResolver;
        this.resources = resources;
    }

    public ResourceHelperKeyPairProvider(String[] resources, PasswordFinder passwordFinder, ClassResolver classResolver) {
        this.classResolver = classResolver;
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public PasswordFinder getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(PasswordFinder passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>(this.resources.length);
        for (String resource : this.resources) {
            InputStream is;
            InputStreamReader isr;
            PEMParser r;
            block8: {
                r = null;
                isr = null;
                is = null;
                try {
                    is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.classResolver, (String)resource);
                    isr = new InputStreamReader(is);
                    r = new PEMParser((Reader)isr);
                    Object o = r.readObject();
                    JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                    pemConverter.setProvider("BC");
                    if (this.passwordFinder != null && o instanceof PEMEncryptedKeyPair) {
                        JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                        PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(this.passwordFinder.getPassword());
                        o = pemConverter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor));
                    }
                    if (o instanceof PEMKeyPair) {
                        o = pemConverter.getKeyPair((PEMKeyPair)o);
                        keys.add((KeyPair)o);
                        break block8;
                    }
                    if (!(o instanceof KeyPair)) break block8;
                    keys.add((KeyPair)o);
                }
                catch (Exception e) {
                    try {
                        this.log.warn("Unable to read key", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
                        throw throwable;
                    }
                    IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
                    continue;
                }
            }
            IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
        }
        return keys;
    }
}

