/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowException;
import org.apache.camel.component.servicenow.ServiceNowExceptionModel;
import org.apache.camel.component.servicenow.ServiceNowParam;
import org.apache.camel.component.servicenow.auth.AuthenticationRequestFilter;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public final class ServiceNowClient {
    private final ServiceNowConfiguration configuration;
    private final WebClient client;

    ServiceNowClient(CamelContext camelContext, ServiceNowConfiguration configuration) throws Exception {
        this.configuration = configuration;
        this.client = WebClient.create((String)configuration.getApiUrl(), Arrays.asList(new AuthenticationRequestFilter(configuration), new JacksonJsonProvider(configuration.getMapper())), (boolean)true);
        ServiceNowClient.configureRequestContext(camelContext, configuration, this.client);
        ServiceNowClient.configureTls(camelContext, configuration, this.client);
        ServiceNowClient.configureHttpClientPolicy(camelContext, configuration, this.client);
        ServiceNowClient.configureProxyAuthorizationPolicy(camelContext, configuration, this.client);
    }

    public ServiceNowClient types(MediaType type) {
        return this.types(type, type);
    }

    public ServiceNowClient types(MediaType accept, MediaType type) {
        this.client.accept(new MediaType[]{accept});
        this.client.type(type);
        return this;
    }

    public ServiceNowClient path(Object path) {
        if (path != null) {
            this.client.path(path);
        }
        return this;
    }

    public ServiceNowClient type(MediaType ct) {
        this.client.type(ct);
        return this;
    }

    public ServiceNowClient type(String type) {
        this.client.type(type);
        return this;
    }

    public ServiceNowClient accept(MediaType ... types) {
        this.client.accept(types);
        return this;
    }

    public ServiceNowClient accept(String ... types) {
        this.client.accept(types);
        return this;
    }

    public ServiceNowClient query(String name, Object ... values) {
        this.client.query(name, values);
        return this;
    }

    public ServiceNowClient query(ServiceNowParam param, Message message) {
        Object value = param.getHeaderValue(message, this.configuration);
        if (value != null) {
            this.client.query(param.getId(), new Object[]{value});
        }
        return this;
    }

    public Response invoke(String httpMethod) throws Exception {
        return this.invoke(httpMethod, null);
    }

    public Response invoke(String httpMethod, Object body) throws Exception {
        Response response = this.client.invoke(httpMethod, body);
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 201: 
            case 204: {
                break;
            }
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 415: {
                ServiceNowExceptionModel model = (ServiceNowExceptionModel)response.readEntity(ServiceNowExceptionModel.class);
                throw new ServiceNowException(code, model.getStatus(), model.getError().get("message"), model.getError().get("detail"));
            }
            default: {
                throw new ServiceNowException(code, (Map)response.readEntity(Map.class));
            }
        }
        return response;
    }

    public ServiceNowClient reset() {
        this.client.back(true);
        this.client.reset();
        this.client.resetQuery();
        return this;
    }

    private static void configureRequestContext(CamelContext context, ServiceNowConfiguration configuration, WebClient client) throws Exception {
        WebClient.getConfig((Object)client).getRequestContext().put("org.apache.cxf.http.header.split", true);
    }

    private static void configureTls(CamelContext camelContext, ServiceNowConfiguration configuration, WebClient client) throws Exception {
        SSLContextParameters sslContextParams = configuration.getSslContextParameters();
        if (sslContextParams != null) {
            HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
            TLSClientParameters tlsClientParams = conduit.getTlsClientParameters();
            if (tlsClientParams == null) {
                tlsClientParams = new TLSClientParameters();
            }
            SSLContext sslContext = sslContextParams.createSSLContext(camelContext);
            tlsClientParams.setSSLSocketFactory(sslContext.getSocketFactory());
            conduit.setTlsClientParameters(tlsClientParams);
        }
    }

    private static void configureHttpClientPolicy(CamelContext context, ServiceNowConfiguration configuration, WebClient client) throws Exception {
        HTTPClientPolicy httpPolicy = configuration.getHttpClientPolicy();
        if (httpPolicy == null) {
            String host = configuration.getProxyHost();
            Integer port = configuration.getProxyPort();
            if (host != null && port != null) {
                httpPolicy = new HTTPClientPolicy();
                httpPolicy.setProxyServer(host);
                httpPolicy.setProxyServerPort(port.intValue());
            }
        }
        if (httpPolicy != null) {
            WebClient.getConfig((Object)client).getHttpConduit().setClient(httpPolicy);
        }
    }

    private static void configureProxyAuthorizationPolicy(CamelContext context, ServiceNowConfiguration configuration, WebClient client) throws Exception {
        ProxyAuthorizationPolicy proxyPolicy = configuration.getProxyAuthorizationPolicy();
        if (proxyPolicy == null) {
            String username = configuration.getProxyUserName();
            String password = configuration.getProxyPassword();
            if (username != null && password != null) {
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setAuthorizationType("Basic");
                proxyPolicy.setUserName(username);
                proxyPolicy.setPassword(password);
            }
        }
        if (proxyPolicy != null) {
            WebClient.getConfig((Object)client).getHttpConduit().setProxyAuthorization(proxyPolicy);
        }
    }
}

