package org.wildfly.swarm.config.keycloak.server;

import org.wildfly.swarm.config.keycloak.server.Spi;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SpiConsumer<T extends Spi<T>> {

	/**
	 * Configure a pre-constructed instance of Spi resource
	 * 
	 * @parameter Instance of Spi to configure
	 * @return nothing
	 */
	void accept(T value);

	default SpiConsumer<T> andThen(SpiConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}