package org.wildfly.swarm.config.keycloak.server.spi;

import org.wildfly.swarm.config.keycloak.server.spi.Provider;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ProviderConsumer<T extends Provider<T>> {

	/**
	 * Configure a pre-constructed instance of Provider resource
	 * 
	 * @parameter Instance of Provider to configure
	 * @return nothing
	 */
	void accept(T value);

	default ProviderConsumer<T> andThen(ProviderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}