package org.jboss.shrinkwrap.descriptor.api.beans11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.beans11.Exclude;
import org.jboss.shrinkwrap.descriptor.api.beans.*;
/**
 * This interface defines the contract for the <code> scan </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface Scan<T> extends Child<T>, 
    JavaeeScanCommType<T, Scan<T>,
    Exclude<Scan<T>>> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: Scan ElementName: javaee:exclude ElementType : exclude
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude</code> element will be created and returned.
    * Otherwise, the first existing <code>exclude</code> element will be returned.
    * @return the instance defined for the element <code>exclude</code> 
    */
   public Exclude<Scan<T>> getOrCreateExclude();

   /**
    * Creates a new <code>exclude</code> element 
    * @return the new created instance of <code>Exclude<Scan<T>></code> 
    */
   public Exclude<Scan<T>> createExclude();

   /**
    * Returns all <code>exclude</code> elements
    * @return list of <code>exclude</code> 
    */
   public List<Exclude<Scan<T>>> getAllExclude();

   /**
    * Removes all <code>exclude</code> elements 
    * @return the current instance of <code>Exclude<Scan<T>></code> 
    */
   public Scan<T> removeAllExclude();
}
